/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.jira.issue.action.IssueActionComparator;
import com.atlassian.jira.issue.tabpanels.GenericMessageAction;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueTabPanel2;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsReply;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelInvoker;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelReply;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AllTabPanel
extends AbstractIssueTabPanel2 {
    private final PluginAccessor pluginAccessor;
    private final IssueTabPanelInvoker issueTabPanelInvoker;

    public AllTabPanel(PluginAccessor pluginAccessor, IssueTabPanelInvoker issueTabPanelInvoker) {
        this.pluginAccessor = pluginAccessor;
        this.issueTabPanelInvoker = issueTabPanelInvoker;
    }

    public GetActionsReply getActions(GetActionsRequest request) {
        ArrayList allActions = Lists.newArrayList();
        List<IssueTabPanelModuleDescriptor> showTabPanels = this.getVisibleTabPanels(request);
        for (IssueTabPanelModuleDescriptor issueTabPanel : showTabPanels) {
            GetActionsRequest showAllActionsRequest = new GetActionsRequest(request.issue(), request.remoteUser(), request.isAsynchronous(), true, null);
            List<IssueAction> actions = this.issueTabPanelInvoker.invokeGetActions(showAllActionsRequest, issueTabPanel);
            if (actions == null) continue;
            for (IssueAction action : actions) {
                if (!action.isDisplayActionAllTab()) continue;
                allActions.add(action);
            }
        }
        if (allActions.isEmpty()) {
            return GetActionsReply.create((IssueAction[])new IssueAction[]{new GenericMessageAction(this.descriptor().getI18nBean().getText("viewissue.noactions"))});
        }
        Collections.sort(allActions, IssueActionComparator.COMPARATOR);
        return GetActionsReply.create((Iterable)allActions);
    }

    private List<IssueTabPanelModuleDescriptor> getVisibleTabPanels(GetActionsRequest request) {
        List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(IssueTabPanelModuleDescriptor.class);
        ArrayList visibleTabPanels = Lists.newArrayListWithCapacity((int)descriptors.size());
        for (IssueTabPanelModuleDescriptor tabPanelDescriptor : descriptors) {
            boolean showPanel = this.issueTabPanelInvoker.invokeShowPanel(new ShowPanelRequest(request.issue(), request.remoteUser()), tabPanelDescriptor);
            if (!showPanel || AllTabPanel.class.isAssignableFrom(tabPanelDescriptor.getModuleClass())) continue;
            visibleTabPanels.add(tabPanelDescriptor);
        }
        return visibleTabPanels;
    }

    public ShowPanelReply showPanel(ShowPanelRequest request) {
        return ShowPanelReply.create((boolean)true);
    }
}

