/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views;

import com.atlassian.core.util.XMLUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.IssueHtmlView;
import com.atlassian.jira.issue.views.SingleIssueWriter;
import com.atlassian.jira.issue.views.util.RssViewUtils;
import com.atlassian.jira.issue.views.util.SearchRequestViewBodyWriterUtil;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.issue.views.util.WordViewUtils;
import com.atlassian.jira.plugin.JiraResourcedModuleDescriptor;
import com.atlassian.jira.plugin.issueview.AbstractIssueView;
import com.atlassian.jira.plugin.issueview.IssueViewRequestParams;
import com.atlassian.jira.plugin.searchrequestview.AbstractSearchRequestView;
import com.atlassian.jira.plugin.searchrequestview.RequestHeaders;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchRequestRSSView
extends AbstractSearchRequestView {
    public static final String DEFAULT_DESCRIPTION = "An XML representation of a search request";
    private static final Logger log = LoggerFactory.getLogger(SearchRequestRSSView.class);
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final BuildUtilsInfo buildUtilsInfo;
    private SearchRequestViewBodyWriterUtil searchRequestViewBodyWriterUtil;

    public SearchRequestRSSView(JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, SearchRequestViewBodyWriterUtil searchRequestViewBodyWriterUtil, BuildUtilsInfo buildUtilsInfo) {
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.searchRequestViewBodyWriterUtil = searchRequestViewBodyWriterUtil;
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
    }

    public void writeHeaders(SearchRequest searchRequest, RequestHeaders requestHeaders) {
        WordViewUtils.writeGenericNoCacheHeaders(requestHeaders);
    }

    public void writeSearchResults(SearchRequest searchRequest, final SearchRequestParams searchRequestParams, Writer writer) {
        IssueHtmlView htmlView = this.getIssueHtmlView();
        try {
            if (htmlView == null) {
                writer.write("Could not find plugin of class 'IssueHtmlView'.  This is needed for this plugin to work");
                return;
            }
            writer.write(this.getHeader(searchRequest, searchRequestParams));
            final String styleSheet = this.getIssueHtmlView().getStyleSheetHtml();
            SingleIssueWriter singleIssueWriter = new SingleIssueWriter(){

                @Override
                public void writeIssue(Issue issue, AbstractIssueView issueView, Writer writer) throws IOException {
                    if (log.isDebugEnabled()) {
                        log.debug("About to write RSS view for issue [" + issue.getKey() + "].");
                    }
                    Map<String, Object> bodyParams = JiraVelocityUtils.getDefaultVelocityParams(SearchRequestRSSView.this.authenticationContext);
                    String htmlBody = issueView.getBody(issue, (IssueViewRequestParams)searchRequestParams);
                    bodyParams.put("issue", issue);
                    bodyParams.put("issueDescription", XMLUtils.escape((String)(styleSheet + " " + htmlBody)));
                    String body = SearchRequestRSSView.this.descriptor.getHtml("view", bodyParams);
                    writer.write(body);
                }
            };
            this.searchRequestViewBodyWriterUtil.writeBody(writer, this.getIssueHtmlView(), searchRequest, singleIssueWriter, searchRequestParams.getPagerFilter());
            writer.write(this.getFooter());
        }
        catch (SearchException e) {
            throw new DataAccessException((Throwable)e);
        }
        catch (IOException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private IssueHtmlView getIssueHtmlView() {
        return SearchRequestViewUtils.getIssueView(IssueHtmlView.class);
    }

    private String getHeader(SearchRequest searchRequest, SearchRequestParams searchRequestParams) {
        return this.getHeader(searchRequest, searchRequestParams, this.applicationProperties, (JiraResourcedModuleDescriptor)this.descriptor);
    }

    private String getHeader(SearchRequest searchRequest, SearchRequestParams searchRequestParams, ApplicationProperties applicationProperties, JiraResourcedModuleDescriptor descriptor) {
        long startIssue = searchRequestParams.getPagerFilter().getStart();
        long totalIssues = this.getSearchCount(searchRequest, searchRequestParams);
        long tempMax = searchRequestParams.getPagerFilter().getMax() < 0 ? 0L : (long)searchRequestParams.getPagerFilter().getMax();
        long endIssue = Math.min(startIssue + tempMax, totalIssues);
        Map<String, Object> headerParams = JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext);
        headerParams.put("title", SearchRequestViewUtils.getTitle(searchRequest, applicationProperties.getString("jira.title")));
        VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(applicationProperties).getJiraVelocityRequestContext();
        headerParams.put("link", SearchRequestViewUtils.getLink(searchRequest, velocityRequestContext.getBaseUrl(), this.authenticationContext.getUser()));
        headerParams.put("buildInfo", this.buildUtilsInfo.getBuildInformation());
        headerParams.put("currentDate", new Date());
        headerParams.put("description", this.getDescription(searchRequest));
        headerParams.put("rssLocale", RssViewUtils.getRssLocale(this.authenticationContext.getLocale()));
        headerParams.put("startissue", startIssue);
        headerParams.put("endissue", endIssue);
        headerParams.put("totalissue", totalIssues);
        headerParams.put("version", this.buildUtilsInfo.getVersion());
        headerParams.put("buildNumber", this.buildUtilsInfo.getCurrentBuildNumber());
        headerParams.put("buildDate", new SimpleDateFormat("dd-MM-yyyy").format(this.buildUtilsInfo.getCurrentBuildDate()));
        return descriptor.getHtml("header", headerParams);
    }

    private String getDescription(SearchRequest searchRequest) {
        return searchRequest.getDescription() != null ? searchRequest.getDescription() : DEFAULT_DESCRIPTION;
    }

    private String getFooter() {
        return this.descriptor.getHtml("footer", Collections.emptyMap());
    }

    private long getSearchCount(SearchRequest searchRequest, SearchRequestParams searchRequestParams) {
        String searchCount = (String)searchRequestParams.getSession().get("searchCount");
        if (StringUtils.isNumeric((CharSequence)searchCount)) {
            return Long.parseLong(searchCount);
        }
        try {
            return this.searchRequestViewBodyWriterUtil.searchCount(searchRequest);
        }
        catch (SearchException se) {
            return 0L;
        }
    }
}

