/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views.csv;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.export.customfield.CsvIssueExporter;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.csv.AbstractCsvSearchRequestView;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.component.TableLayoutFactory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SearchRequestCsvViewAllFields
extends AbstractCsvSearchRequestView {
    private final JiraAuthenticationContext authenticationContext;
    private final TableLayoutFactory tableLayoutFactory;
    private static final String CUSTOM_FIELD_ID = "custom_field";
    private static final List<String> FIELD_ORDERING = Lists.newArrayList((Object[])new String[]{"summary", "issuekey", "issuetype", "status", "project", "priority", "resolution", "assignee", "reporter", "creator", "created", "updated", "lastViewed", "resolutiondate", "versions", "fixVersions", "components", "duedate", "votes", "labels", "description", "environment", "watches", "worklog", "timeoriginalestimate", "timeestimate", "timespent", "progress", "workratio", "aggregatetimeoriginalestimate", "aggregatetimeestimate", "aggregatetimespent", "aggregateprogress", "security", "issuelinks", "attachment", "custom_field", "comment"});
    private static final Comparator<Field> fieldLayoutComparator = (firstField, secondField) -> {
        boolean bothCustomFields;
        boolean firstIsCustomField = firstField instanceof CustomField;
        boolean secondIsCustomField = secondField instanceof CustomField;
        boolean bl = bothCustomFields = firstIsCustomField && secondIsCustomField;
        if (bothCustomFields) {
            return firstField.getName().compareTo(secondField.getName());
        }
        String firstId = firstField.getId();
        if (firstIsCustomField) {
            firstId = CUSTOM_FIELD_ID;
        }
        String secondId = secondField.getId();
        if (secondIsCustomField) {
            secondId = CUSTOM_FIELD_ID;
        }
        Integer firstIndex = FIELD_ORDERING.indexOf(firstId);
        Integer secondIndex = FIELD_ORDERING.indexOf(secondId);
        if (firstIndex == -1 && secondIndex == -1) {
            return firstField.getName().compareTo(secondField.getName());
        }
        if (firstIndex == -1) {
            return 1;
        }
        if (secondIndex == -1) {
            return -1;
        }
        return firstIndex - secondIndex;
    };

    public SearchRequestCsvViewAllFields(ApplicationProperties applicationProperties, CsvIssueExporter csvIssueExporter, JiraAuthenticationContext authenticationContext, TableLayoutFactory tableLayoutFactory) {
        super(applicationProperties, csvIssueExporter);
        this.authenticationContext = authenticationContext;
        this.tableLayoutFactory = tableLayoutFactory;
    }

    @Override
    protected List<Field> getFieldsToBeExported(SearchRequest searchRequest) {
        ArrayList fields = Lists.newArrayList(this.tableLayoutFactory.getAllUserCsvColumnsFields(searchRequest, this.authenticationContext.getLoggedInUser()));
        Collections.sort(fields, fieldLayoutComparator);
        return fields;
    }
}

