/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views.util;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.mail.SubscriptionMailQueueMockRequest;
import com.atlassian.jira.plugin.issueview.IssueView;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestView;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.BuildUtilsInfoImpl;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.plugin.PluginAccessor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class SearchRequestViewUtils {
    private static final BuildUtilsInfo BUILD_UTILS_INFO = new BuildUtilsInfoImpl();

    public static String getLink(SearchRequest searchRequest, String baseUrl, ApplicationUser user) {
        if (searchRequest.getId() != null) {
            return baseUrl + SearchRequestViewUtils.getSearchService().getIssueSearchPath(user, SearchService.IssueSearchParameters.builder().filterId(searchRequest.getId()).build());
        }
        return baseUrl + SearchRequestViewUtils.getSearchService().getIssueSearchPath(user, SearchService.IssueSearchParameters.builder().query(searchRequest.getQuery()).build());
    }

    private static SearchService getSearchService() {
        return (SearchService)ComponentAccessor.getComponent(SearchService.class);
    }

    public static <V extends IssueView> V getIssueView(Class<V> issueViewClass) {
        PluginAccessor pluginAccessor = (PluginAccessor)ComponentAccessor.getComponentOfType(PluginAccessor.class);
        List modules = pluginAccessor.getEnabledModulesByClass(issueViewClass);
        if (!modules.isEmpty()) {
            return (V)((IssueView)modules.get(0));
        }
        return null;
    }

    public static <V extends SearchRequestView> V getSearchRequestView(Class<V> searchRequestViewClass) {
        PluginAccessor pluginAccessor = (PluginAccessor)ComponentAccessor.getComponentOfType(PluginAccessor.class);
        List modules = pluginAccessor.getEnabledModulesByClass(searchRequestViewClass);
        if (!modules.isEmpty()) {
            return (V)((SearchRequestView)modules.get(0));
        }
        return null;
    }

    public static String getTitle(SearchRequest searchRequest, String jiraTitle) {
        return searchRequest.getName() != null ? searchRequest.getName() + " (" + jiraTitle + ")" : jiraTitle;
    }

    public static String getFilename(SearchRequest searchRequest, String jiraTitle, Date date) {
        String base = SearchRequestViewUtils.getTitle(searchRequest, jiraTitle);
        String timestamp = ((DateTimeFormatterFactory)ComponentAccessor.getComponent(DateTimeFormatterFactory.class)).formatter().forLoggedInUser().withStyle(DateTimeStyle.ISO_8601_DATE_TIME).format(date);
        return base + " " + timestamp;
    }

    public static String getGeneratedInfo(ApplicationUser user) {
        I18nBean i18nBean = new I18nBean(user);
        if (user != null) {
            return i18nBean.getText("rss.search.request.view.header.text.with.user", new Date().toString(), user.getDisplayName(), BUILD_UTILS_INFO.getBuildInformation());
        }
        return i18nBean.getText("rss.search.request.view.header.text.with.out.user", new Date().toString(), BUILD_UTILS_INFO.getBuildInformation());
    }

    public static HttpServletRequest getMockRequest(String baseUrl) {
        return new SubscriptionMailQueueMockRequest(SearchRequestViewUtils.getContextPath(baseUrl));
    }

    private static String getContextPath(String baseURL) {
        try {
            return new URL(baseURL).getPath();
        }
        catch (MalformedURLException e) {
            return "Incorrect baseURL format: " + baseURL;
        }
    }
}

