/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.clause;

import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.WorklogClauseQueryFactory;
import com.atlassian.jira.jql.query.WorklogQueryExecutor;
import com.atlassian.jira.jql.query.WorklogQueryRegistry;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.MultiClause;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

@NonInjectableComponent
public class WorklogClausesTransformerVisitor
implements ClauseVisitor<Clause> {
    private static final Clause FALSE = new AlwaysFalseClause();
    private final WorklogQueryRegistry queryRegistry;
    private final WorklogQueryExecutor worklogQueryExecutor;
    private final QueryCreationContext queryCreationContext;

    private WorklogClausesTransformerVisitor(QueryCreationContext queryCreationContext, WorklogQueryRegistry queryRegistry, WorklogQueryExecutor worklogQueryExecutor) {
        this.queryCreationContext = queryCreationContext;
        this.queryRegistry = queryRegistry;
        this.worklogQueryExecutor = worklogQueryExecutor;
    }

    public Clause visit(AndClause andClause) {
        return this.simplify((MultiClause)new AndClause(this.transformMultiClauseExecutingWorklogConditions((MultiClause)andClause, BooleanClause.Occur.MUST)));
    }

    public Clause visit(OrClause orClause) {
        return this.simplify((MultiClause)new OrClause(this.transformMultiClauseExecutingWorklogConditions((MultiClause)orClause, BooleanClause.Occur.SHOULD)));
    }

    public Clause visit(final TerminalClause clause) {
        return (Clause)this.queryRegistry.getClauseQueryFactory(this.queryCreationContext, clause).map((Function)new Function<WorklogClauseQueryFactory, Clause>(){

            @Override
            public Clause apply(WorklogClauseQueryFactory input) {
                return WorklogClausesTransformerVisitor.this.toIssueSet(input.getWorklogQuery(WorklogClausesTransformerVisitor.this.queryCreationContext, clause));
            }
        }).getOrElse((Object)clause);
    }

    private Clause simplify(MultiClause multiClause) {
        return multiClause.getClauses().size() == 1 ? (Clause)Iterables.getOnlyElement((Iterable)multiClause.getClauses()) : multiClause;
    }

    private Collection<Clause> transformMultiClauseExecutingWorklogConditions(MultiClause multiClause, BooleanClause.Occur operator) {
        ImmutableList.Builder newSubClauses = ImmutableList.builder();
        BooleanQuery.Builder luceneWorklogsQuery = new BooleanQuery.Builder();
        for (Clause clause : multiClause.getClauses()) {
            Option<Query> maybeWorklogQuery = this.convertClauseToWorklogQuery(clause);
            if (maybeWorklogQuery.isDefined()) {
                luceneWorklogsQuery.add((Query)maybeWorklogQuery.get(), operator);
                continue;
            }
            newSubClauses.add(clause.accept((ClauseVisitor)this));
        }
        if (luceneWorklogsQuery.build().clauses().size() > 0) {
            newSubClauses.add((Object)this.toIssueSet((Query)luceneWorklogsQuery.build()));
        }
        return newSubClauses.build();
    }

    private Option<Query> convertClauseToWorklogQuery(Clause clause) {
        Option<WorklogClauseQueryFactory> worklogClauseFactory;
        if (clause instanceof TerminalClause && (worklogClauseFactory = this.queryRegistry.getClauseQueryFactory(this.queryCreationContext, (TerminalClause)clause)).isDefined()) {
            return Option.some((Object)((WorklogClauseQueryFactory)worklogClauseFactory.get()).getWorklogQuery(this.queryCreationContext, (TerminalClause)clause));
        }
        return Option.none();
    }

    private Clause toIssueSet(Query worklogQuery) {
        ArrayList issueIds = Lists.newArrayList(this.worklogQueryExecutor.executeWorklogQuery(worklogQuery, this.queryCreationContext));
        return issueIds.isEmpty() ? FALSE : new TerminalClauseImpl("issuekey", issueIds.toArray(new Long[issueIds.size()]));
    }

    public Clause visit(NotClause notClause) {
        return new NotClause((Clause)notClause.getSubClause().accept((ClauseVisitor)this));
    }

    public Clause visit(WasClause clause) {
        return clause;
    }

    public Clause visit(ChangedClause clause) {
        return clause;
    }

    @InjectableComponent
    public static class Factory {
        private final WorklogQueryRegistry queryRegistry;
        private final WorklogQueryExecutor worklogQueryExecutor;

        public Factory(WorklogQueryRegistry queryRegistry, WorklogQueryExecutor worklogQueryExecutor) {
            this.queryRegistry = queryRegistry;
            this.worklogQueryExecutor = worklogQueryExecutor;
        }

        public WorklogClausesTransformerVisitor create(QueryCreationContext queryCreationContext) {
            return new WorklogClausesTransformerVisitor(queryCreationContext, this.queryRegistry, this.worklogQueryExecutor);
        }
    }

    private static final class AlwaysFalseClause
    extends AndClause {
        public AlwaysFalseClause() {
            super(new Clause[]{new TerminalClauseImpl("issuekey", Operator.EQUALS, "FALSE"), new TerminalClauseImpl("issuekey", Operator.NOT_EQUALS, "FALSE")});
        }
    }
}

