/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.index.ManagedIndexSearcher;
import com.atlassian.jira.issue.search.SearchProviderFactory;
import com.atlassian.jira.jql.query.HistoryPredicateQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lucene.ConstantScorePrefixQuery;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.operator.Operator;
import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.JoinUtil;
import org.apache.lucene.search.join.ScoreMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangedClauseQueryFactory {
    private static final Logger log = LoggerFactory.getLogger(ChangedClauseQueryFactory.class);
    private final SearchProviderFactory searchProviderFactory;
    private final HistoryPredicateQueryFactory changedPredicateQueryFactory;

    public ChangedClauseQueryFactory(SearchProviderFactory searchProviderFactory, HistoryPredicateQueryFactory changedPredicateQueryFactory) {
        this.searchProviderFactory = searchProviderFactory;
        this.changedPredicateQueryFactory = changedPredicateQueryFactory;
    }

    public QueryFactoryResult create(ApplicationUser searcher, ChangedClause clause) {
        Query changedQuery = this.makeQuery(searcher, clause);
        ManagedIndexSearcher historySearcher = this.searchProviderFactory.getSearcher("changes");
        try {
            if (log.isDebugEnabled()) {
                log.debug("Running Changed query (" + clause + "): " + changedQuery);
            }
            Query joinQuery = JoinUtil.createJoinQuery((String)"issue_id", (boolean)false, (String)"issue_id", (Query)changedQuery, (IndexSearcher)historySearcher, (ScoreMode)ScoreMode.None);
            boolean mustNotOccur = clause.getOperator() != Operator.CHANGED;
            return new QueryFactoryResult(joinQuery, mustNotOccur);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Query makeQuery(ApplicationUser searcher, ChangedClause clause) {
        BooleanQuery.Builder outerQuery = new BooleanQuery.Builder();
        BooleanQuery.Builder changedQuery = new BooleanQuery.Builder();
        PrefixQuery toQuery = this.createQuery(clause, "ch_from");
        if (clause.getPredicate() == null) {
            changedQuery.add((Query)toQuery, BooleanClause.Occur.SHOULD);
        } else {
            BooleanQuery predicateQuery = this.changedPredicateQueryFactory.makePredicateQuery(searcher, clause.getField().toLowerCase(), clause.getPredicate(), true);
            changedQuery.add((Query)predicateQuery, BooleanClause.Occur.MUST);
            changedQuery.add((Query)toQuery, BooleanClause.Occur.MUST);
        }
        outerQuery.add((Query)changedQuery.build(), BooleanClause.Occur.SHOULD);
        return outerQuery.build();
    }

    private PrefixQuery createQuery(ChangedClause clause, String documentField) {
        return ConstantScorePrefixQuery.build(new Term(clause.getField().toLowerCase() + "." + documentField, "ch-"));
    }
}

