/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.sharing.search.SharedEntitySearchContext;
import com.atlassian.jira.sharing.search.SharedEntitySearchParametersBuilder;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SavedFilterValuesGenerator
implements ClauseValuesGenerator {
    private final SearchRequestService searchRequestService;

    public SavedFilterValuesGenerator(SearchRequestService searchRequestService) {
        this.searchRequestService = searchRequestService;
    }

    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        SharedEntitySearchParametersBuilder builder = new SharedEntitySearchParametersBuilder().setName(StringUtils.isBlank((CharSequence)valuePrefix) ? "" : valuePrefix).setEntitySearchContext(SharedEntitySearchContext.USE);
        SharedEntitySearchResult sharedEntitySearchResult = this.searchRequestService.search((JiraServiceContext)new JiraServiceContextImpl(searcher), builder.toSearchParameters(), 0, maxNumResults);
        List searchRequests = sharedEntitySearchResult.getResults();
        ArrayList savedFilterValues = Lists.newArrayListWithCapacity((int)searchRequests.size());
        for (SearchRequest searchRequest : searchRequests) {
            if (savedFilterValues.size() == maxNumResults) break;
            savedFilterValues.add(new ClauseValuesGenerator.Result(searchRequest.getName()));
        }
        return new ClauseValuesGenerator.Results((List)savedFilterValues);
    }
}

