/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.monitoring.jmx;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.monitoring.jmx.InstrumentationMetricsCollector;
import com.atlassian.jira.monitoring.jmx.JmxConfigurationChangedEvent;
import com.atlassian.jira.monitoring.jmx.JmxMetricsExposer;
import com.atlassian.jira.monitoring.jmx.bean.JmxMBean;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxMetricsExposerImpl
implements JmxMetricsExposer,
Startable {
    private static final String JMX_STATUS_PROPERTY_KEY = "jira.monitoring.jmx.enabled";
    private static final String JMX_STATUS_CLUSTER_CHANNEL = "jira.monitoring.jmx";
    private static final Logger log = LoggerFactory.getLogger(JmxMetricsExposerImpl.class);
    private final InstrumentationMetricsCollector instrumentationMetricsCollector;
    private final ApplicationProperties applicationProperties;
    private final MessageHandlerService messageHandlerService;
    private final EventPublisher eventPublisher;
    private final ClusterMessageConsumer messageConsumer = this::handleClusterMessage;
    private static final Object exposeLock = new Object();

    public JmxMetricsExposerImpl(InstrumentationMetricsCollector instrumentationMetricsCollector, ApplicationProperties applicationProperties, MessageHandlerService messageHandlerService, EventPublisher eventPublisher) {
        this.instrumentationMetricsCollector = instrumentationMetricsCollector;
        this.applicationProperties = applicationProperties;
        this.messageHandlerService = messageHandlerService;
        this.eventPublisher = eventPublisher;
        messageHandlerService.registerListener(JMX_STATUS_CLUSTER_CHANNEL, this.messageConsumer);
    }

    private void register() {
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        Collection<JmxMBean> mBeans = this.collectMetrics();
        for (JmxMBean jmxBean : mBeans) {
            try {
                beanServer.registerMBean(jmxBean, new ObjectName("com.atlassian.jira:type=" + jmxBean.getName()));
            }
            catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
                log.debug("Exception occurred during registering new Jmx Value : {}", (Object)jmxBean.getName(), (Object)e);
            }
        }
    }

    private void unregister() {
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        Collection<JmxMBean> mBeans = this.collectMetrics();
        for (JmxMBean jmxBean : mBeans) {
            try {
                beanServer.unregisterMBean(new ObjectName("com.atlassian.jira:type=" + jmxBean.getName()));
            }
            catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException e) {
                log.debug("Exception occurred during unregistering Jmx Value : {}", (Object)jmxBean.getName(), (Object)e);
            }
        }
    }

    private Collection<JmxMBean> collectMetrics() {
        return this.instrumentationMetricsCollector.collect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startExposing() {
        Object object = exposeLock;
        synchronized (object) {
            this.register();
            this.applicationProperties.setOption(JMX_STATUS_PROPERTY_KEY, true);
        }
        this.eventPublisher.publish((Object)new JmxConfigurationChangedEvent(true));
    }

    @Override
    public void publishRefreshMessage() {
        this.messageHandlerService.sendMessage("ALL", new Message(JMX_STATUS_CLUSTER_CHANNEL, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopExposing() {
        Object object = exposeLock;
        synchronized (object) {
            this.unregister();
            this.applicationProperties.setOption(JMX_STATUS_PROPERTY_KEY, false);
        }
        this.eventPublisher.publish((Object)new JmxConfigurationChangedEvent(false));
    }

    @Override
    public List<String> getExposedMetricNames() {
        return this.collectMetrics().stream().map(JmxMBean::getName).collect(Collectors.toList());
    }

    @Override
    public boolean isJmxEnabled() {
        return this.applicationProperties.getOption(JMX_STATUS_PROPERTY_KEY);
    }

    @Override
    public void init() {
        this.refreshState();
    }

    public void start() throws Exception {
        this.init();
    }

    private void refreshState() {
        if (this.isJmxEnabled()) {
            this.startExposing();
        } else {
            this.stopExposing();
        }
    }

    private void handleClusterMessage(String channel, String message, String senderId) {
        this.refreshState();
    }
}

