/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.monitoring.jmx.bean;

import com.atlassian.jira.monitoring.jmx.bean.JmxMBean;
import com.atlassian.jira.util.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.ReflectionException;

public class DynamicJmxValue
implements DynamicMBean,
JmxMBean {
    private static final Map<Class<?>, String> TYPES = ImmutableMap.builder().put(String.class, (Object)"java.lang.String").put(Integer.class, (Object)"int").put(Long.class, (Object)"long").put(Double.class, (Object)"double").put(Float.class, (Object)"float").build();
    private com.google.common.base.Supplier<MBeanAttributeInfo[]> attributeInfos;
    private final Map<String, Supplier<Attribute>> attributeMap;
    private final String name;

    public DynamicJmxValue(String name, Map<String, Supplier<Attribute>> attributeMap) {
        this.name = name;
        this.attributeMap = attributeMap;
        this.attributeInfos = Suppliers.memoize(this::determineAttributeInfo);
    }

    @Override
    public Object getAttribute(String name) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Supplier<Attribute> supplier = this.attributeMap.get(name);
        Attribute attribute = supplier == null ? null : (Attribute)supplier.get();
        return attribute == null ? null : attribute.getValue();
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        return Stream.of(attributes).map(this.attributeMap::get).map(Supplier::get).collect(Collectors.toCollection(AttributeList::new));
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        return null;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        return null;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this.getClass().getName(), null, (MBeanAttributeInfo[])this.attributeInfos.get(), null, null, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private MBeanAttributeInfo[] determineAttributeInfo() {
        return (MBeanAttributeInfo[])this.attributeMap.values().stream().map(this::createMBeanInfo).toArray(MBeanAttributeInfo[]::new);
    }

    private MBeanAttributeInfo createMBeanInfo(Supplier<Attribute> supplier) {
        String type;
        Attribute attribute = (Attribute)supplier.get();
        Object value = attribute.getValue();
        String string = type = value == null ? null : TYPES.get(value.getClass());
        if (type == null) {
            type = "java.lang.Object";
        }
        return new MBeanAttributeInfo(attribute.getName(), type, null, true, false, false);
    }
}

