/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.database.DatabaseAccessor;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Optional;
import org.ofbiz.core.entity.GenericValue;

public class MySQL56LongerThanTwoBytesCharsFallback {
    private static final int LAST_THREE_BYTES_HIGH_SURROGATE = 255;
    private static final char UNSUPPORTED_CHARACTER = '\ufffd';
    private final LazyReference<Boolean> isMySQL;

    public MySQL56LongerThanTwoBytesCharsFallback() {
        this.isMySQL = new LazyReference<Boolean>(){

            protected Boolean create() throws Exception {
                DatabaseAccessor possibleConfiguration = (DatabaseAccessor)ComponentAccessor.getComponent(DatabaseAccessor.class);
                return Optional.ofNullable(possibleConfiguration).map(x -> DatabaseType.MY_SQL.getTypeName().equalsIgnoreCase(possibleConfiguration.getDatabaseType())).orElse(false);
            }
        };
    }

    MySQL56LongerThanTwoBytesCharsFallback(final boolean isMySQL) {
        this.isMySQL = new LazyReference<Boolean>(){

            protected Boolean create() throws Exception {
                return isMySQL;
            }
        };
    }

    public void escapeGenericValue(GenericValue gv) {
        if (((Boolean)this.isMySQL.get()).booleanValue()) {
            for (String key : gv.getAllKeys()) {
                Object value = gv.get(key);
                if (!(value instanceof String)) continue;
                gv.set(key, (Object)MySQL56LongerThanTwoBytesCharsFallback.removeMb4Characters((String)value));
            }
        }
    }

    public static String removeMb4Characters(String str) {
        if (str == null) {
            return null;
        }
        return str.codePoints().map(x -> {
            if (Character.isSupplementaryCodePoint(x) && Character.highSurrogate(x) > '\u00ff') {
                return 65533;
            }
            return x;
        }).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }
}

