/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.ofbiz.sql;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationLoader;
import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.diagnostic.connection.DatabaseDiagnosticsCollectorDelegate;
import com.atlassian.jira.diagnostic.connection.DiagnosticConnection;
import com.atlassian.jira.ofbiz.sql.TransactionFactoryInterfaceWrapper;
import com.atlassian.jira.ofbiz.sql.mysql56.Escape4ByteLongCharactersConnection;
import java.sql.Connection;
import java.sql.SQLException;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.transaction.JNDIFactory;
import org.ofbiz.core.entity.transaction.TransactionFactoryInterface;

public class JiraSupportedDatabasesCompatibleJNDIFactory
extends TransactionFactoryInterfaceWrapper {
    private final boolean isMySQL56;
    private DatabaseDiagnosticsCollectorDelegate diagnosticsCollector;

    public JiraSupportedDatabasesCompatibleJNDIFactory() {
        super((TransactionFactoryInterface)new JNDIFactory());
        DatabaseConfigurationLoader loader = (DatabaseConfigurationLoader)ComponentAccessor.getComponent(DatabaseConfigurationLoader.class);
        DatabaseConfig config = loader.loadDatabaseConfiguration();
        this.isMySQL56 = DatabaseType.MY_SQL.getTypeName().equalsIgnoreCase(config.getDatabaseType());
    }

    @Override
    public Connection getConnection(String s) throws SQLException, GenericEntityException {
        Connection connection = this.wrapForDiagnostics(super.getConnection(s));
        if (this.isMySQL56) {
            return new Escape4ByteLongCharactersConnection(connection);
        }
        return connection;
    }

    private Connection wrapForDiagnostics(Connection connection) {
        if (this.diagnosticsCollector == null) {
            this.diagnosticsCollector = this.diagnosticsCollector();
        }
        if (this.diagnosticsCollector != null && this.diagnosticsCollector.isEnabled()) {
            DiagnosticConnection diagnosticConnection = new DiagnosticConnection(connection, this.diagnosticsCollector);
            this.diagnosticsCollector.trackConnection(diagnosticConnection);
            return diagnosticConnection;
        }
        return connection;
    }

    private DatabaseDiagnosticsCollectorDelegate diagnosticsCollector() {
        try {
            return (DatabaseDiagnosticsCollectorDelegate)ComponentAccessor.getComponent(DatabaseDiagnosticsCollectorDelegate.class);
        }
        catch (IllegalStateException e) {
            return null;
        }
    }
}

