/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding;

import com.atlassian.jira.onboarding.OnboardingStore;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.opensymphony.module.propertyset.PropertySet;

public class OnboardingStoreImpl
implements OnboardingStore {
    private final UserPropertyManager userPropertyManager;

    public OnboardingStoreImpl(UserPropertyManager userPropertyManager) {
        this.userPropertyManager = userPropertyManager;
    }

    @Override
    public boolean isSet(ApplicationUser user, String key) {
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        return propertySet.exists(key);
    }

    @Override
    public void setBoolean(ApplicationUser user, String key, boolean value) {
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        propertySet.setBoolean(key, value);
    }

    @Override
    public boolean getBoolean(ApplicationUser user, String key) {
        if (this.isSet(user, key)) {
            PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
            return propertySet.getBoolean(key);
        }
        return false;
    }

    @Override
    public void setString(ApplicationUser user, String key, String value) {
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        propertySet.setString(key, value);
    }

    @Override
    public String getString(ApplicationUser user, String key) {
        if (this.isSet(user, key)) {
            PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
            return propertySet.getString(key);
        }
        return null;
    }
}

