/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.permission.data;

import com.atlassian.jira.permission.PermissionGrant;
import com.atlassian.jira.permission.PermissionGrantInput;
import com.atlassian.jira.permission.PermissionHolder;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import io.atlassian.fugue.Either;

public final class PermissionGrantAsPureData {
    public static final Function<PermissionGrant, PermissionGrantAsPureData> TO_PURE_DATA = new Function<PermissionGrant, PermissionGrantAsPureData>(){

        public PermissionGrantAsPureData apply(PermissionGrant input) {
            return PermissionGrantAsPureData.of(input);
        }
    };
    public static final Function<PermissionGrantInput, PermissionGrantAsPureData> TO_PURE_DATA_2 = new Function<PermissionGrantInput, PermissionGrantAsPureData>(){

        public PermissionGrantAsPureData apply(PermissionGrantInput input) {
            return PermissionGrantAsPureData.of(input);
        }
    };
    public static final Function<PermissionGrantAsPureData, PermissionGrant> TO_GRANT = new Function<PermissionGrantAsPureData, PermissionGrant>(){

        public PermissionGrant apply(PermissionGrantAsPureData input) {
            return input.getGrant();
        }
    };
    public static final Function<PermissionGrantAsPureData, PermissionGrantInput> TO_GRANT_INPUT = new Function<PermissionGrantAsPureData, PermissionGrantInput>(){

        public PermissionGrantInput apply(PermissionGrantAsPureData input) {
            return input.getGrantInput();
        }
    };
    private final Either<PermissionGrant, PermissionGrantInput> actual;

    private PermissionGrantAsPureData(PermissionGrant grant, PermissionGrantInput grantData) {
        this.actual = grant != null ? Either.left((Object)grant) : Either.right((Object)grantData);
    }

    public Either<PermissionGrant, PermissionGrantInput> getActual() {
        return this.actual;
    }

    public PermissionGrant getGrant() {
        return (PermissionGrant)this.actual.left().get();
    }

    public PermissionGrantInput getGrantInput() {
        return (PermissionGrantInput)this.actual.right().get();
    }

    public static PermissionGrantAsPureData of(PermissionGrant grant) {
        return new PermissionGrantAsPureData(grant, null);
    }

    public static PermissionGrantAsPureData of(PermissionGrantInput grantData) {
        return new PermissionGrantAsPureData(null, grantData);
    }

    public static Predicate<PermissionGrant> equalToModuloId(final PermissionGrantInput data) {
        return new Predicate<PermissionGrant>(){

            public boolean apply(PermissionGrant input) {
                return PermissionGrantAsPureData.of(input).equals(PermissionGrantAsPureData.of(data));
            }
        };
    }

    private PermissionHolder getHolder() {
        return (PermissionHolder)this.actual.fold(PermissionGrant::getHolder, PermissionGrantInput::getHolder);
    }

    private ProjectPermissionKey getPermission() {
        return (ProjectPermissionKey)this.actual.fold(PermissionGrant::getPermission, PermissionGrantInput::getPermission);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionGrantAsPureData that = (PermissionGrantAsPureData)o;
        return Objects.equal((Object)this.getHolder().getParameter(), (Object)that.getHolder().getParameter()) && Objects.equal((Object)this.getHolder().getType().getKey(), (Object)that.getHolder().getType().getKey()) && Objects.equal((Object)this.getHolder().getType().requiresParameter(), (Object)that.getHolder().getType().requiresParameter()) && Objects.equal((Object)this.getPermission(), (Object)that.getPermission());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getHolder(), this.getPermission()});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("holder", (Object)this.getHolder()).add("permission", (Object)this.getPermission()).toString();
    }
}

