/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.bigpipe;

import com.atlassian.jira.plugin.bigpipe.PrioritizedRunnable;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CollectingExecutor
implements Executor {
    public static final int DEFAULT_PRIORITY = 100;
    private final Queue<PrioritizedRunnable> queue = new PriorityBlockingQueue<PrioritizedRunnable>();
    private volatile boolean closed;

    @Override
    public void execute(@Nonnull Runnable command) {
        if (this.closed) {
            throw new IllegalStateException("Cannot execute new commands - executor is closed");
        }
        PrioritizedRunnable prioritizedCommand = command instanceof PrioritizedRunnable ? (PrioritizedRunnable)command : new PrioritizedRunnable(100, command);
        this.queue.add(prioritizedCommand);
    }

    public void close() {
        this.closed = true;
    }

    public Optional<Runnable> pop() {
        return Optional.ofNullable(this.queue.poll());
    }

    public Executor prioritized(@Nullable Integer priority) {
        if (priority == null) {
            priority = 100;
        }
        return new PrioritizedExecutor(priority);
    }

    private class PrioritizedExecutor
    implements Executor {
        private final int priority;

        public PrioritizedExecutor(int priority) {
            this.priority = priority;
        }

        @Override
        public void execute(@Nonnull Runnable command) {
            CollectingExecutor.this.execute(new PrioritizedRunnable(this.priority, command));
        }
    }
}

