/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.validator.NumberOfArgumentsValidator;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.user.util.Users;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class AbstractUserBasedFunction
extends AbstractJqlFunction {
    private static final int MIN_EXPECTED_ARGS = 0;
    private static final int MAX_EXPECTED_ARGS = 1;
    protected final UserUtil userUtil;
    protected final GlobalPermissionManager globalPermissionManager;

    public AbstractUserBasedFunction(UserUtil userUtil, GlobalPermissionManager globalPermissionManager) {
        this.userUtil = (UserUtil)Assertions.notNull((String)"userUtil", (Object)userUtil);
        this.globalPermissionManager = (GlobalPermissionManager)Assertions.notNull((String)"globalPermissionManager", (Object)globalPermissionManager);
    }

    @Nonnull
    public MessageSet validate(ApplicationUser searcher, FunctionOperand functionOperand, TerminalClause terminalClause) {
        I18nHelper i18n = this.getI18n();
        if (Users.isAnonymous((ApplicationUser)searcher) && !this.isAnonymousAccessAllowed(functionOperand)) {
            return this.getMessageForDisallowedAnonymousAccess(i18n);
        }
        return this.validateQuery(functionOperand, i18n);
    }

    protected boolean isAnonymousAccessAllowed(FunctionOperand functionOperand) {
        if (this.isSelfSearch(functionOperand)) {
            return false;
        }
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.USER_PICKER, null);
    }

    private boolean isSelfSearch(FunctionOperand functionOperand) {
        return functionOperand.getArgs().isEmpty();
    }

    protected MessageSet getMessageForDisallowedAnonymousAccess(I18nHelper i18n) {
        MessageSetImpl messageSet = new MessageSetImpl();
        messageSet.addErrorMessage(i18n.getText("jira.jql.function.anonymous.disallowed", this.getFunctionName()));
        return messageSet;
    }

    protected MessageSet validateQuery(FunctionOperand functionOperand, I18nHelper i18n) {
        String username;
        MessageSet messages = this.validateNumberOfArgs(functionOperand, i18n);
        if (messages.hasAnyErrors()) {
            return messages;
        }
        if (functionOperand.getArgs().size() == 1 && this.userUtil.getUserByName(username = (String)functionOperand.getArgs().get(0)) == null) {
            messages.addErrorMessage(i18n.getText(this.getUserNotFoundMessageKey(), functionOperand.getName(), username));
        }
        return messages;
    }

    private MessageSet validateNumberOfArgs(FunctionOperand functionOperand, I18nHelper i18n) {
        return new NumberOfArgumentsValidator(0, 1, i18n).validate(functionOperand);
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 0;
    }

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand functionOperand, TerminalClause terminalClause) {
        ApplicationUser user;
        Assertions.notNull((String)"queryCreationContext", (Object)queryCreationContext);
        if (functionOperand.getArgs().size() == 1) {
            String username = (String)functionOperand.getArgs().get(0);
            user = this.userUtil.getUserByName(username);
        } else {
            user = queryCreationContext.getApplicationUser();
        }
        if (user == null) {
            return Collections.emptyList();
        }
        return this.getFunctionValuesList(queryCreationContext, functionOperand, user);
    }

    protected abstract List<QueryLiteral> getFunctionValuesList(QueryCreationContext var1, FunctionOperand var2, ApplicationUser var3);

    protected abstract String getUserNotFoundMessageKey();
}

