/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.navigation;

import com.atlassian.jira.plugin.webfragment.DefaultWebFragmentContext;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BannerRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(BannerRenderer.class);
    private static final String LOCATION = "jira-banner";
    private final WebInterfaceManager webInterfaceManager;
    private final Supplier<Map<String, Object>> contextSupplier;

    @Inject
    public BannerRenderer(WebInterfaceManager webInterfaceManager) {
        this(webInterfaceManager, DefaultWebFragmentContext::get);
    }

    @VisibleForTesting
    BannerRenderer(WebInterfaceManager webInterfaceManager, Supplier<Map<String, Object>> contextSupplier) {
        this.webInterfaceManager = webInterfaceManager;
        this.contextSupplier = contextSupplier;
    }

    public void writeBanners(Writer writer) {
        Map<String, Object> context = this.contextSupplier.get();
        Option displayableWebPanelDescriptors = Iterables.first((Iterable)this.webInterfaceManager.getDisplayableWebPanelDescriptors(LOCATION, context));
        for (WebPanelModuleDescriptor descriptor : displayableWebPanelDescriptors) {
            try {
                ((WebPanel)descriptor.getModule()).writeHtml(writer, context);
            }
            catch (IOException | RuntimeException e) {
                LOG.debug(String.format("Unable to render banner '%s'.", descriptor.getCompleteKey()), (Throwable)e);
            }
        }
    }
}

