/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.searchrequestview;

import com.atlassian.jira.plugin.issueview.IssueViewFieldParams;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.web.bean.PagerFilter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class SearchRequestParamsImpl
implements SearchRequestParams {
    private Map<String, Object> sessionParamsMap;
    private PagerFilter pagerFilter;
    private IssueViewFieldParams issueViewFieldParams;
    private String userAgent;
    private boolean returnMax;
    private final String fileExtension;

    public SearchRequestParamsImpl(HttpSession session, PagerFilter pagerFilter, Map<String, ?> otherParams, IssueViewFieldParams issueViewFieldParams, String userAgent, String fileExtension) {
        this.issueViewFieldParams = issueViewFieldParams;
        this.sessionParamsMap = SearchRequestParamsImpl.convertSessionToMap(session);
        if (otherParams != null && !otherParams.isEmpty()) {
            this.sessionParamsMap.putAll(otherParams);
        }
        this.pagerFilter = pagerFilter;
        this.userAgent = userAgent;
        this.fileExtension = fileExtension;
    }

    public static Map<String, Object> convertSessionToMap(HttpSession session) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            map.put(attributeName, session.getAttribute(attributeName));
        }
        return map;
    }

    public Map<String, Object> getSession() {
        return Collections.unmodifiableMap(this.sessionParamsMap);
    }

    public PagerFilter getPagerFilter() {
        return this.pagerFilter;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public IssueViewFieldParams getIssueViewFieldParams() {
        return this.issueViewFieldParams;
    }

    public void setReturnMax(boolean returnMax) {
        this.returnMax = returnMax;
    }

    public boolean isReturnMax() {
        return this.returnMax;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }
}

