/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.portal.PortalPageService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.dashboard.DashboardUtil;
import com.atlassian.jira.plugin.webfragment.JiraWebContext;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;

public abstract class AbstractDashboardCondition
implements Condition {
    public static final String CONTEXT_KEY_DASHBOARD_ID = "dashboardId";

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        ApplicationUser appUser = this.getApplicationUser(context);
        DashboardId dashboardId = (DashboardId)context.get(CONTEXT_KEY_DASHBOARD_ID);
        if (dashboardId != null && DashboardUtil.toLong((DashboardId)dashboardId) != null && appUser != null) {
            JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(appUser);
            PortalPage portalPage = this.getPortalPageService().getPortalPage((JiraServiceContext)jiraServiceContext, DashboardUtil.toLong((DashboardId)dashboardId));
            return this.shouldDisplay(jiraServiceContext, portalPage);
        }
        return false;
    }

    private ApplicationUser getApplicationUser(Map<String, Object> context) {
        return JiraWebContext.from(context).getUser().orElse(null);
    }

    PortalPageService getPortalPageService() {
        return (PortalPageService)ComponentAccessor.getComponentOfType(PortalPageService.class);
    }

    abstract boolean shouldDisplay(JiraServiceContextImpl var1, PortalPage var2);
}

