/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment.conditions;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.webfragment.conditions.AbstractWebCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import java.util.Map;
import java.util.Optional;

public class JiraGlobalPermissionCondition
extends AbstractWebCondition {
    private final GlobalPermissionManager permissionManager;
    private GlobalPermissionKey permissionKey;

    public JiraGlobalPermissionCondition(GlobalPermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        String providedKey = params.get("permission");
        this.permissionKey = this.legacyPermissionKey(providedKey).orElse(GlobalPermissionKey.of((String)providedKey));
        super.init(params);
    }

    public boolean shouldDisplay(ApplicationUser user, JiraHelper jiraHelper) {
        return this.permissionManager.hasPermission(this.permissionKey, user);
    }

    private Optional<GlobalPermissionKey> legacyPermissionKey(String providedKey) {
        int legacyPermission = Permissions.getType((String)providedKey);
        if (legacyPermission != -1) {
            GlobalPermissionKey globalPermissionKey = (GlobalPermissionKey)GlobalPermissionKey.GLOBAL_PERMISSION_ID_TRANSLATION.get((Object)legacyPermission);
            return Optional.ofNullable(globalPermissionKey);
        }
        return Optional.empty();
    }
}

