/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.InitializingComponent;
import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureEvent;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.i18n.CachingI18nFactory;
import com.atlassian.jira.license.LicenseChangedEvent;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.cdn.CDNStrategy;
import com.atlassian.plugin.webresource.cdn.CdnStrategyProvider;
import com.atlassian.sal.api.license.BaseLicenseDetails;
import com.atlassian.sal.api.license.LicenseHandler;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class JiraWebResourceIntegration
implements WebResourceIntegration,
InitializingComponent {
    private static final Logger log = Logger.getLogger(JiraWebResourceIntegration.class);
    static final String INCREMENTAL_CACHE_ENABLED = "jira.wrm.incremental.cache.enabled";
    private final PluginAccessor pluginAccessor;
    private final ApplicationProperties applicationProperties;
    private final VelocityRequestContextFactory requestContextFactory;
    private final BuildUtilsInfo buildUtilsInfo;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final CachingI18nFactory i18nFactory;
    private final JiraHome jiraHome;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final PluginEventManager pluginEventManager;
    private final LocaleManager localeManager;
    private final ResettableLazyReference<Boolean> isCdnFunctionalityAvailable = Lazy.resettable((Supplier)new Supplier<Boolean>(){

        @Override
        public Boolean get() {
            LicenseHandler licenseHandler = (LicenseHandler)ComponentAccessor.getOSGiComponentInstanceOfType(LicenseHandler.class);
            if (licenseHandler == null) {
                return false;
            }
            return JiraWebResourceIntegration.this.featureManager.isEnabled(JiraFeatureFlagRegistrar.CDN_STATIC_ASSETS) && (JiraSystemProperties.getInstance().isDevMode() || licenseHandler.getAllProductLicenses().stream().allMatch(BaseLicenseDetails::isDataCenter));
        }
    });
    private final AtomicBoolean isCdnServiceLookupFailureLogged = new AtomicBoolean();

    public JiraWebResourceIntegration(PluginAccessor pluginAccessor, ApplicationProperties applicationProperties, VelocityRequestContextFactory requestContextFactory, BuildUtilsInfo buildUtilsInfo, JiraAuthenticationContext jiraAuthenticationContext, CachingI18nFactory i18nFactory, JiraHome jiraHome, EventPublisher eventPublisher, FeatureManager featureManager, PluginEventManager pluginEventManager, LocaleManager localeManager) {
        this.i18nFactory = i18nFactory;
        this.pluginAccessor = (PluginAccessor)Assertions.notNull((String)"pluginAccessor", (Object)pluginAccessor);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
        this.requestContextFactory = (VelocityRequestContextFactory)Assertions.notNull((String)"requestContextFactory", (Object)requestContextFactory);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Assertions.notNull((String)"jiraAuthenticationContext", (Object)jiraAuthenticationContext);
        this.jiraHome = (JiraHome)Assertions.notNull((String)"jiraHome", (Object)jiraHome);
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.pluginEventManager = pluginEventManager;
        this.localeManager = localeManager;
    }

    @EventListener
    public void onLicenseChanged(LicenseChangedEvent event) {
        this.isCdnFunctionalityAvailable.reset();
    }

    @EventListener
    public void onPluginSystemStarted(PluginFrameworkStartedEvent event) {
        this.isCdnFunctionalityAvailable.reset();
    }

    @EventListener
    public void onFeatureFlagChange(FeatureEvent event) {
        this.isCdnFunctionalityAvailable.reset();
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginAccessor;
    }

    public PluginEventManager getPluginEventManager() {
        return this.pluginEventManager;
    }

    public Map<String, Object> getRequestCache() {
        return JiraAuthenticationContextImpl.getRequestCache();
    }

    public String getSystemCounter() {
        return this.applicationProperties.getDefaultBackedString("jira.webresource.flushcounter");
    }

    public String getSystemBuildNumber() {
        return this.buildUtilsInfo.getCurrentBuildNumber();
    }

    public String getHostApplicationVersion() {
        return this.buildUtilsInfo.getVersion();
    }

    public String getBaseUrl() {
        return this.getBaseUrl(UrlMode.AUTO);
    }

    public String getBaseUrl(UrlMode urlMode) {
        switch (urlMode) {
            case RELATIVE: {
                HttpServletRequest httpServletRequest = ExecutingHttpRequest.get();
                if (httpServletRequest != null) {
                    return httpServletRequest.getContextPath();
                }
            }
            case AUTO: {
                return this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
            }
            case ABSOLUTE: {
                return this.requestContextFactory.getJiraVelocityRequestContext().getCanonicalBaseUrl();
            }
        }
        throw new AssertionError((Object)("Unsupported URLMode: " + urlMode));
    }

    public String getSuperBatchVersion() {
        return this.applicationProperties.getDefaultBackedString("jira.webresource.superbatch.flushcounter");
    }

    public String getStaticResourceLocale() {
        I18nHelper i18n = this.jiraAuthenticationContext.getI18nHelper();
        return i18n.getLocale().toString() + this.i18nFactory.getStateHashCode();
    }

    public String getI18nStateHash() {
        return this.i18nFactory.getStateHashCode();
    }

    @Nonnull
    public File getTemporaryDirectory() {
        return new File(this.jiraHome.getLocalHome(), "tmp" + File.separator + "webresources");
    }

    @Override
    public void afterInstantiation() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public CDNStrategy getCDNStrategy() {
        if (!((Boolean)this.isCdnFunctionalityAvailable.get()).booleanValue()) {
            return null;
        }
        CdnStrategyProvider cdnStrategyProvider = (CdnStrategyProvider)ComponentAccessor.getOSGiComponentInstanceOfType(CdnStrategyProvider.class);
        try {
            CDNStrategy cdnStrategy = cdnStrategyProvider.getCdnStrategy().orElse(null);
            this.isCdnServiceLookupFailureLogged.set(false);
            return cdnStrategy;
        }
        catch (RuntimeException e) {
            if (this.isCdnServiceLookupFailureLogged.compareAndSet(false, true)) {
                log.error((Object)("An error happened during " + CdnStrategyProvider.class.getSimpleName() + " service lookup, CDN will not be available"), (Throwable)e);
            }
            return null;
        }
    }

    public Locale getLocale() {
        return this.jiraAuthenticationContext.getLocale();
    }

    public Iterable<Locale> getSupportedLocales() {
        return this.localeManager.getInstalledLocales();
    }

    public String getI18nRawText(Locale locale, String key) {
        return this.i18nFactory.getInstance(locale).getUnescapedText(key);
    }

    public String getI18nText(Locale locale, String key) {
        return this.i18nFactory.getInstance(locale).getText(key);
    }

    public Set<String> allowedCondition1Keys() {
        throw new UnsupportedOperationException();
    }

    public Set<String> allowedTransform1Keys() {
        throw new UnsupportedOperationException();
    }

    public boolean forbidCondition1AndTransformer1() {
        return false;
    }

    public boolean isIncrementalCacheEnabled() {
        return this.featureManager.getDarkFeatures().isFeatureEnabled(INCREMENTAL_CACHE_ENABLED);
    }

    public boolean isCompiledResourceEnabled() {
        return true;
    }
}

