/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.archiving;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.archiving.ArchivedProjectManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;

public class ArchivedStatistics {
    private final CachedReference<ArchivedStatisticsData> issuesCountCache;
    private final ProjectManager projectManager;
    private final IssueManager issueManager;
    private final OfBizDelegator ofBizDelegator;

    public ArchivedStatistics(CacheManager cacheManager, ProjectManager projectManager, IssueManager issueManager, OfBizDelegator ofBizDelegator) {
        this.projectManager = projectManager;
        this.issueManager = issueManager;
        this.ofBizDelegator = ofBizDelegator;
        this.issuesCountCache = cacheManager.getCachedReference(ArchivedProjectManager.class.getName() + ".cache", this::calculateArchivedStatisticsData, new CacheSettingsBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).replicateViaInvalidation().build());
    }

    public void invalidate() {
        this.issuesCountCache.reset();
    }

    public Integer getTotalArchivedIssuesCount() {
        return ((ArchivedStatisticsData)this.issuesCountCache.get()).getTotalArchivedIssuesCount();
    }

    public Integer getIssuesInArchivedProjectsCount() {
        return ((ArchivedStatisticsData)this.issuesCountCache.get()).getIssuesInArchivedProjectsCount();
    }

    public Integer getArchivedIssuesCount() {
        return ((ArchivedStatisticsData)this.issuesCountCache.get()).getArchivedIssuesCount();
    }

    private Integer calculateIssuesInArchivedProjectsCount() {
        return (int)this.projectManager.getArchivedProjects().stream().mapToLong(project -> this.issueManager.getIssueCountForProject(project.getId())).sum();
    }

    private Integer calculateArchivedIssuesCount() {
        return (int)this.ofBizDelegator.getCountByAnd("Issue", (Map)ImmutableMap.of((Object)"archived", (Object)DatabaseUtil.booleanToChar1(true)));
    }

    private Integer calculateTotalArchivedIssuesCount(@Nullable Integer issuesInArchivedProjectsCount) {
        Integer issuesInArchivedProjects = issuesInArchivedProjectsCount == null ? this.calculateIssuesInArchivedProjectsCount() : issuesInArchivedProjectsCount;
        List activeProjectIds = this.projectManager.getProjects().stream().map(Project::getId).collect(Collectors.toList());
        if (activeProjectIds.isEmpty()) {
            return issuesInArchivedProjects;
        }
        EntityExpr whereActiveProject = new EntityExpr("project", EntityOperator.IN, activeProjectIds);
        EntityExpr whereArchived = new EntityExpr("archived", EntityOperator.EQUALS, (Object)DatabaseUtil.booleanToChar1(true));
        EntityConditionList conditions = new EntityConditionList((List)ImmutableList.of((Object)whereActiveProject, (Object)whereArchived), EntityOperator.AND);
        return issuesInArchivedProjects + (int)this.ofBizDelegator.getCountByAnd("Issue", (EntityCondition)conditions);
    }

    private ArchivedStatisticsData calculateArchivedStatisticsData() {
        Integer issuesInArchivedProjectsCount = this.calculateIssuesInArchivedProjectsCount();
        return new ArchivedStatisticsData(this.calculateTotalArchivedIssuesCount(issuesInArchivedProjectsCount), this.calculateArchivedIssuesCount(), issuesInArchivedProjectsCount);
    }

    private static class ArchivedStatisticsData {
        private Integer totalArchivedIssuesCount;
        private Integer archivedIssuesCount;
        private Integer issuesInArchivedProjectsCount;

        ArchivedStatisticsData(Integer totalArchivedIssuesCount, Integer archivedIssuesCount, Integer issuesInArchivedProjectsCount) {
            this.totalArchivedIssuesCount = totalArchivedIssuesCount;
            this.archivedIssuesCount = archivedIssuesCount;
            this.issuesInArchivedProjectsCount = issuesInArchivedProjectsCount;
        }

        Integer getTotalArchivedIssuesCount() {
            return this.totalArchivedIssuesCount;
        }

        Integer getArchivedIssuesCount() {
            return this.archivedIssuesCount;
        }

        Integer getIssuesInArchivedProjectsCount() {
            return this.issuesInArchivedProjectsCount;
        }
    }
}

