/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.propertyset.CachingOfBizPropertySet;
import com.atlassian.jira.propertyset.JiraCachingPropertySet;
import com.atlassian.jira.propertyset.JiraCachingPropertySetManager;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.propertyset.OfBizPropertyEntryStore;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertyImplementationException;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.module.propertyset.memory.MemoryPropertySet;
import com.opensymphony.module.propertyset.ofbiz.OFBizPropertySet;
import java.util.Map;
import javax.annotation.Nonnull;

public class DefaultJiraPropertySetFactory
implements JiraPropertySetFactory {
    private static final Long DEFAULT_ENTITY_ID = 1L;
    private static final Map<String, Object> NO_CONFIG = ImmutableMap.of();
    private static final Map<String, Class<? extends PropertySet>> IMPLEMENTATIONS = ImmutableMap.builder().put((Object)"ofbiz", OFBizPropertySet.class).put((Object)"ofbiz-cached", CachingOfBizPropertySet.class).put((Object)"memory", MemoryPropertySet.class).build();
    private final JiraCachingPropertySetManager jiraCachingPropertySetManager;
    private final ClassLoader classLoader;
    private final OfBizPropertyEntryStore ofBizPropertyEntryStore;

    @Deprecated
    public DefaultJiraPropertySetFactory() {
        this((JiraCachingPropertySetManager)ComponentAccessor.getComponent(JiraCachingPropertySetManager.class), (OfBizPropertyEntryStore)ComponentAccessor.getComponent(OfBizPropertyEntryStore.class));
    }

    public DefaultJiraPropertySetFactory(JiraCachingPropertySetManager jiraCachingPropertySetManager, OfBizPropertyEntryStore ofBizPropertyEntryStore) {
        this.jiraCachingPropertySetManager = (JiraCachingPropertySetManager)Assertions.notNull((String)"jiraCachingPropertySetManager", (Object)jiraCachingPropertySetManager);
        this.ofBizPropertyEntryStore = (OfBizPropertyEntryStore)Assertions.notNull((String)"ofBizPropertyEntryStore", (Object)ofBizPropertyEntryStore);
        this.classLoader = this.getClass().getClassLoader();
    }

    @Nonnull
    public PropertySet buildNoncachingPropertySet(String entityName) {
        return this.buildNoncachingPropertySet(entityName, DEFAULT_ENTITY_ID);
    }

    @Nonnull
    public PropertySet buildNoncachingPropertySet(String entityName, Long entityId) {
        return this.createPropertySet("ofbiz", (Map<String, Object>)FieldMap.build((String)"delegator.name", (Object)"default", (String)"entityName", (Object)entityName, (String)"entityId", (Object)entityId));
    }

    @Nonnull
    public PropertySet buildCachingDefaultPropertySet(String entityName) {
        return this.buildCachingPropertySet(entityName, DEFAULT_ENTITY_ID);
    }

    @Nonnull
    public PropertySet buildCachingDefaultPropertySet(String entityName, boolean bulkLoad) {
        return this.buildCachingPropertySet(entityName, DEFAULT_ENTITY_ID);
    }

    @Nonnull
    public PropertySet buildCachingPropertySet(String entityName, Long entityId, boolean bulkLoad) {
        return this.buildCachingPropertySet(entityName, entityId);
    }

    @Nonnull
    public PropertySet buildCachingPropertySet(String entityName, Long entityId) {
        return new CachingOfBizPropertySet(this.ofBizPropertyEntryStore, entityName, entityId);
    }

    @Nonnull
    public PropertySet buildCachingPropertySet(PropertySet propertySet, boolean bulkLoad) {
        Assertions.notNull((String)"propertySet is a required parameter", (Object)propertySet);
        PropertySet cachingPropertySet = this.createPropertySet("cached", (Map<String, Object>)FieldMap.build((String)"PropertySet", (Object)propertySet, (String)"bulkload", (Object)bulkLoad));
        if (cachingPropertySet instanceof JiraCachingPropertySet) {
            this.jiraCachingPropertySetManager.register((JiraCachingPropertySet)cachingPropertySet);
        }
        return cachingPropertySet;
    }

    @Nonnull
    public PropertySet buildMemoryPropertySet(String entityName, Long entityId) {
        PropertySet dbPropertySet = this.buildNoncachingPropertySet(entityName, entityId);
        PropertySet memoryPropertySet = this.createPropertySet("memory", (Map<String, Object>)Maps.newHashMap());
        PropertySetManager.clone((PropertySet)dbPropertySet, (PropertySet)memoryPropertySet);
        return memoryPropertySet;
    }

    @Nonnull
    private PropertySet createPropertySet(String propertySetDelegator, Map<String, Object> ofbizArgs) {
        Class<? extends PropertySet> implClass = IMPLEMENTATIONS.get(propertySetDelegator);
        if (implClass != null) {
            return this.createPropertySet(implClass, ofbizArgs);
        }
        return PropertySetManager.getInstance((String)propertySetDelegator, ofbizArgs, (ClassLoader)this.classLoader);
    }

    @Nonnull
    PropertySet createPropertySet(Class<? extends PropertySet> propertySetClass, Map<String, Object> args) {
        try {
            PropertySet ps = propertySetClass.newInstance();
            ps.init(NO_CONFIG, args);
            return ps;
        }
        catch (InstantiationException e) {
            throw new PropertyImplementationException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyImplementationException((Throwable)e);
        }
    }
}

