/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.ProjectRoleActorsCacheSettings;
import com.atlassian.jira.security.roles.ProjectRoleActorsImpl;
import com.atlassian.jira.security.roles.ProjectRoleAndActorStore;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@EventComponent
public class CachingProjectRoleAndActorStore
implements ProjectRoleAndActorStore {
    private final ProjectRoleAndActorStore delegate;
    private final RoleActorFactory roleActorFactory;
    private final CachedReference<AllProjectRoles> projectRoles;
    final Cache<Long, Map<Optional<Long>, ProjectRoleActors>> projectRoleActorsCache;

    public CachingProjectRoleAndActorStore(ProjectRoleAndActorStore delegate, RoleActorFactory roleActorFactory, CacheManager cacheManager, ProjectRoleActorsCacheSettings projectRoleActorsCacheSettings) {
        this.delegate = delegate;
        this.roleActorFactory = roleActorFactory;
        this.projectRoles = cacheManager.getCachedReference(this.getClass().getName() + ".projectRoles", () -> new AllProjectRoles(this.delegate.getAllProjectRoles()));
        this.projectRoleActorsCache = cacheManager.getCache(this.getClass().getName() + ".projectRoleActors", this::loadRolesFromDelegate, projectRoleActorsCacheSettings.getSettings());
    }

    @Override
    public Collection<ProjectRole> getAllProjectRoles() {
        return ((AllProjectRoles)this.projectRoles.get()).getAll();
    }

    @Override
    public ProjectRole getProjectRole(Long id) {
        return ((AllProjectRoles)this.projectRoles.get()).get(id);
    }

    @Override
    public ProjectRole getProjectRoleByName(String name) {
        return ((AllProjectRoles)this.projectRoles.get()).getByName(name);
    }

    @Override
    public ProjectRole addProjectRole(ProjectRole projectRole) {
        try {
            ProjectRole projectRole2 = this.delegate.addProjectRole(projectRole);
            return projectRole2;
        }
        finally {
            this.projectRoles.reset();
        }
    }

    @Override
    public void updateProjectRole(ProjectRole projectRole) {
        try {
            this.delegate.updateProjectRole(projectRole);
        }
        finally {
            this.projectRoles.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteProjectRole(ProjectRole projectRole) {
        long projectRoleId = (Long)Assertions.notNull((String)"projectRole.getId()", (Object)((ProjectRole)Assertions.notNull((String)"projectRole", (Object)projectRole)).getId());
        try {
            this.delegate.deleteProjectRole(projectRole);
        }
        finally {
            this.projectRoles.reset();
            this.projectRoleActorsCache.remove((Object)projectRoleId);
        }
    }

    @Override
    public DefaultRoleActors getDefaultRoleActors(Long projectRoleId) {
        return this.getProjectRoleActors(projectRoleId, null);
    }

    @Override
    public ProjectRoleActors getProjectRoleActors(@Nonnull Long projectRoleId, Long projectId) {
        ProjectRoleActors actors = (ProjectRoleActors)((Map)this.projectRoleActorsCache.get(Assertions.notNull((String)"projectRoleId", (Object)projectRoleId))).get(Optional.ofNullable(projectId));
        return actors == null ? new ProjectRoleActorsImpl(projectId, projectRoleId, Sets.newHashSet()) : actors;
    }

    @Override
    public Collection<ProjectRoleActors> getProjectRoleActorsByRoleId(@Nonnull Long projectRoleId) {
        return ((Map)this.projectRoleActorsCache.get(Assertions.notNull((String)"projectRoleId", (Object)projectRoleId))).values();
    }

    @Override
    public void updateProjectRoleActors(ProjectRoleActors projectRoleActors) {
        if (projectRoleActors.getProjectId() == null) {
            this.updateDefaultRoleActors((DefaultRoleActors)projectRoleActors);
            return;
        }
        this.delegate.updateProjectRoleActors(projectRoleActors);
        this.projectRoleActorsCache.remove((Object)projectRoleActors.getProjectRoleId());
    }

    @Override
    public void updateDefaultRoleActors(DefaultRoleActors defaultRoleActors) {
        this.delegate.updateDefaultRoleActors(defaultRoleActors);
        this.projectRoleActorsCache.remove((Object)defaultRoleActors.getProjectRoleId());
    }

    @Override
    public void applyDefaultsRolesToProject(Project project) {
        this.delegate.applyDefaultsRolesToProject(project);
        this.projectRoleActorsCache.removeAll();
    }

    @Override
    public void removeAllRoleActorsByKeyAndType(String key, String type) {
        this.delegate.removeAllRoleActorsByKeyAndType(key, type);
        this.projectRoleActorsCache.removeAll();
    }

    @Override
    public void removeAllRoleActorsByProject(Project project) {
        this.delegate.removeAllRoleActorsByProject(project);
        this.projectRoleActorsCache.removeAll();
    }

    @Override
    public Collection<Long> getProjectIdsContainingRoleActorByKeyAndType(String key, String type) {
        return this.delegate.getProjectIdsContainingRoleActorByKeyAndType(key, type);
    }

    @Override
    public List<Long> roleActorOfTypeExistsForProjects(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String projectRoleParameter) {
        return this.delegate.roleActorOfTypeExistsForProjects(projectsToLimitBy, projectRole, projectRoleType, projectRoleParameter);
    }

    @Override
    public Map<Long, List<String>> getProjectIdsForUserInGroupsBecauseOfRole(List<Long> projectsToLimitBy, ProjectRole projectRole, String projectRoleType, String userKey) {
        return this.delegate.getProjectIdsForUserInGroupsBecauseOfRole(projectsToLimitBy, projectRole, projectRoleType, userKey);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCaches();
    }

    public void clearCaches() {
        this.projectRoles.reset();
        this.projectRoleActorsCache.removeAll();
    }

    @VisibleForTesting
    protected CachedRoleActors toCachedRoleActor(@Nonnull DefaultRoleActors defaultRoleActors) {
        Set optimizedRoleActors = this.roleActorFactory.optimizeRoleActorSet(defaultRoleActors.getRoleActors());
        return new CachedRoleActors(defaultRoleActors, optimizedRoleActors);
    }

    @Override
    public boolean isGroupUsed(@Nonnull String group) {
        return this.delegate.isGroupUsed(group);
    }

    public Map<Optional<Long>, ProjectRoleActors> loadRolesFromDelegate(@Nonnull Long key) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.delegate.getProjectRoleActorsByRoleId(key).forEach(projectRoleActors -> builder.put(Optional.ofNullable(projectRoleActors.getProjectId()), (Object)this.toCachedRoleActor((DefaultRoleActors)projectRoleActors)));
        return builder.build();
    }

    static class CachedRoleActors
    implements ProjectRoleActors {
        private final DefaultRoleActors delegate;
        private final Set<RoleActor> optimizedProjectRoleSet;

        CachedRoleActors(DefaultRoleActors delegate, Set<RoleActor> optimizedProjectRoleSet) {
            this.delegate = delegate;
            this.optimizedProjectRoleSet = ImmutableSet.copyOf(optimizedProjectRoleSet);
        }

        public boolean contains(ApplicationUser user) {
            for (RoleActor o : this.optimizedProjectRoleSet) {
                if (!o.contains(user)) continue;
                return true;
            }
            return false;
        }

        public Long getProjectId() {
            return this.delegate instanceof ProjectRoleActors ? ((ProjectRoleActors)this.delegate).getProjectId() : null;
        }

        public Set<ApplicationUser> getUsers() {
            return this.delegate.getUsers();
        }

        public Set<ApplicationUser> getApplicationUsers() {
            return this.delegate.getApplicationUsers();
        }

        public Set<RoleActor> getRoleActors() {
            return this.delegate.getRoleActors();
        }

        public Long getProjectRoleId() {
            return this.delegate.getProjectRoleId();
        }

        public Set<RoleActor> getRoleActorsByType(String type) {
            return this.delegate.getRoleActorsByType(type);
        }

        public DefaultRoleActors addRoleActors(Collection<? extends RoleActor> roleActors) {
            return this.delegate.addRoleActors(roleActors);
        }

        public DefaultRoleActors addRoleActor(RoleActor roleActor) {
            return this.delegate.addRoleActor(roleActor);
        }

        public DefaultRoleActors removeRoleActor(RoleActor roleActor) {
            return this.delegate.removeRoleActor(roleActor);
        }

        public DefaultRoleActors removeRoleActors(Collection<? extends RoleActor> roleActors) {
            return this.delegate.removeRoleActors(roleActors);
        }

        public String toString() {
            return "CachedRoleActors[delegate=" + this.delegate + ",optimizedProjectRoleSet=" + this.optimizedProjectRoleSet + ']';
        }
    }

    static class AllProjectRoles {
        private final List<ProjectRole> projectRoles;
        private final Map<Long, ProjectRole> projectRolesById;
        private final Map<String, ProjectRole> projectRolesByName;

        AllProjectRoles(Collection<ProjectRole> projectRoles) {
            ImmutableMap.Builder byId = ImmutableMap.builder();
            ImmutableMap.Builder byName = ImmutableMap.builder();
            for (ProjectRole projectRole : projectRoles) {
                byId.put((Object)projectRole.getId(), (Object)projectRole);
                byName.put((Object)projectRole.getName(), (Object)projectRole);
            }
            this.projectRoles = ImmutableList.copyOf(projectRoles);
            this.projectRolesById = byId.build();
            this.projectRolesByName = byName.build();
        }

        Collection<ProjectRole> getAll() {
            return this.projectRoles;
        }

        ProjectRole get(Long id) {
            return this.projectRolesById.get(id);
        }

        ProjectRole getByName(String name) {
            return this.projectRolesByName.get(name);
        }
    }

    @Immutable
    static final class ProjectRoleActorsKey
    implements Serializable {
        final long projectRoleId;
        final long projectId;

        ProjectRoleActorsKey(Long projectRoleId, Long projectId) {
            this.projectRoleId = (Long)Assertions.notNull((String)"projectRoleId", (Object)projectRoleId);
            this.projectId = (Long)Assertions.notNull((String)"projectId", (Object)projectId);
        }

        public long getProjectRoleId() {
            return this.projectRoleId;
        }

        public long getProjectId() {
            return this.projectId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectRoleActorsKey other = (ProjectRoleActorsKey)o;
            return this.projectRoleId == other.projectRoleId && this.projectId == other.projectId;
        }

        public int hashCode() {
            long value = this.projectId * 31L + this.projectRoleId;
            return (int)(value ^ value >>> 32);
        }

        public String toString() {
            return "ProjectRoleActorsKey[projectRoleId=" + this.projectRoleId + ",projectId=" + this.projectId + ']';
        }
    }
}

