/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles;

import com.atlassian.jira.plugin.roles.ProjectRoleActorModuleDescriptor;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.ozymandias.PluginPointVisitor;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PluginDelegatingRoleActorFactory
implements RoleActorFactory {
    private final PluginAccessor pluginAccessor;

    public PluginDelegatingRoleActorFactory(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public ProjectRoleActor createRoleActor(Long id, Long projectRoleId, Long projectId, String type, String parameter) throws RoleActorDoesNotExistException {
        Map<String, ProjectRoleActorModuleDescriptor> implementations = this.getImplementationsMap();
        ProjectRoleActorModuleDescriptor roleActorModuleDescriptor = this.getRoleActorModuleDescriptor(type, implementations);
        if (roleActorModuleDescriptor == null) {
            throw new IllegalArgumentException("Type " + type + " is not a registered RoleActor implementation");
        }
        RoleActorFactory roleActorFactory = (RoleActorFactory)roleActorModuleDescriptor.getModule();
        return roleActorFactory.createRoleActor(id, projectRoleId, projectId, type, parameter);
    }

    public Set<RoleActor> optimizeRoleActorSet(Set<RoleActor> roleActors) {
        OptimizeRoleActorSetVisitor visitor = new OptimizeRoleActorSetVisitor(roleActors);
        SafePluginPointAccess.to().descriptors(this.getImplementations(), (PluginPointVisitor)visitor);
        return visitor.getOptimizedActors();
    }

    @Nonnull
    public Set<ProjectRoleActor> getAllRoleActorsForUser(@Nullable ApplicationUser user) {
        List actorsFromPluginPoints = SafePluginPointAccess.to().descriptors(this.getImplementations(), (descriptor, factory) -> factory.getAllRoleActorsForUser(user));
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)actorsFromPluginPoints));
    }

    private ProjectRoleActorModuleDescriptor getRoleActorModuleDescriptor(String type, Map<String, ProjectRoleActorModuleDescriptor> implementations) {
        if (implementations == null) {
            return null;
        }
        return implementations.get(type);
    }

    private Map<String, ProjectRoleActorModuleDescriptor> getImplementationsMap() {
        try (Ticker ignored = Timers.start((String)"DefaultRoleActorFactory.getImplementations");){
            List descriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(ProjectRoleActorModuleDescriptor.class);
            HashMap actorsByType = Maps.newHashMapWithExpectedSize((int)descriptors.size());
            for (ProjectRoleActorModuleDescriptor projectRoleModuleDescriptor : descriptors) {
                actorsByType.put(projectRoleModuleDescriptor.getKey(), projectRoleModuleDescriptor);
            }
            HashMap hashMap = actorsByType;
            return hashMap;
        }
    }

    private Collection<ProjectRoleActorModuleDescriptor> getImplementations() {
        return this.getImplementationsMap().values();
    }

    private static class OptimizeRoleActorSetVisitor
    implements PluginPointVisitor<ProjectRoleActorModuleDescriptor, RoleActorFactory> {
        private Set<RoleActor> optimizedActors;

        public OptimizeRoleActorSetVisitor(Set<RoleActor> optimizedActors) {
            this.optimizedActors = optimizedActors;
        }

        public void visit(ProjectRoleActorModuleDescriptor projectRoleActorModuleDescriptor, RoleActorFactory roleActorFactory) {
            this.optimizedActors = roleActorFactory.optimizeRoleActorSet(this.optimizedActors);
        }

        public Set<RoleActor> getOptimizedActors() {
            return this.optimizedActors;
        }
    }
}

