/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.type.AbstractProjectsSecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationRoleSecurityType
extends AbstractProjectsSecurityType {
    private static final Logger log = LoggerFactory.getLogger(ApplicationRoleSecurityType.class);
    public static final String ID = "applicationRole";
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ApplicationAuthorizationService applicationAuthorizationService;
    private final ApplicationRoleManager applicationRoleManager;
    private final UserUtil userUtil;

    public ApplicationRoleSecurityType(JiraAuthenticationContext jiraAuthenticationContext, ApplicationAuthorizationService applicationAuthorizationService, ApplicationRoleManager applicationRoleManager, UserUtil userUtil) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.applicationAuthorizationService = applicationAuthorizationService;
        this.applicationRoleManager = applicationRoleManager;
        this.userUtil = userUtil;
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.permission.types.application.role");
    }

    @Override
    public String getArgumentDisplay(String argument) {
        if (StringUtils.isBlank((CharSequence)argument)) {
            return this.jiraAuthenticationContext.getI18nHelper().getText("admin.permission.types.application.role.any");
        }
        Option<ApplicationRole> role = this.toApplicationRole(argument);
        if (role.isDefined()) {
            return ((ApplicationRole)role.get()).getName();
        }
        return argument;
    }

    @Override
    public String getType() {
        return ID;
    }

    @Override
    public boolean hasPermission(Project project, String applicationRole) {
        return false;
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter) {
        return false;
    }

    @Override
    public boolean hasPermission(Project project, String parameter, ApplicationUser user, boolean issueCreation) {
        return this.hasPermission(parameter, user);
    }

    @Override
    public boolean hasPermission(Issue issue, String parameter, ApplicationUser user, boolean issueCreation) {
        return this.hasPermission(parameter, user);
    }

    private boolean hasPermission(String applicationId, ApplicationUser user) {
        if (user == null) {
            throw new IllegalArgumentException("User passed must not be null");
        }
        if (StringUtils.isBlank((CharSequence)applicationId)) {
            return true;
        }
        Option<ApplicationKey> applicationKey = this.toApplicationKey(applicationId);
        return applicationKey.isDefined() && this.applicationAuthorizationService.canUseApplication(user, (ApplicationKey)applicationKey.get());
    }

    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
        String applicationId = (String)parameters.get(ID);
        if (StringUtils.isNotBlank((CharSequence)applicationId) && this.toApplicationRole(applicationId).isEmpty()) {
            String errorMsg = jiraServiceContext.getI18nBean().getText("admin.permissions.errors.please.select.application.role");
            jiraServiceContext.getErrorCollection().addErrorMessage(errorMsg);
        }
    }

    public Set<ApplicationRole> getApplicationRoles() {
        return this.applicationRoleManager.getRoles();
    }

    @Override
    public Set<ApplicationUser> getUsers(PermissionContext ctx, String applicationId) {
        if (StringUtils.isBlank((CharSequence)applicationId)) {
            return Sets.newHashSet((Iterable)this.userUtil.getAllApplicationUsers());
        }
        Option<ApplicationRole> role = this.toApplicationRole(applicationId);
        if (role.isDefined()) {
            HashSet groups = Sets.newHashSet((Iterable)((ApplicationRole)role.get()).getGroups());
            return this.userUtil.getAllUsersInGroups((Collection)groups);
        }
        return Collections.emptySet();
    }

    private Option<ApplicationRole> toApplicationRole(String applicationId) {
        return this.toApplicationKey(applicationId).flatMap(arg_0 -> ((ApplicationRoleManager)this.applicationRoleManager).getRole(arg_0));
    }

    private Option<ApplicationKey> toApplicationKey(String applicationIdString) {
        try {
            return Option.option((Object)ApplicationKey.valueOf((String)applicationIdString));
        }
        catch (IllegalArgumentException e) {
            log.error("Invalid Application ID supplied: '{}'", (Object)applicationIdString, (Object)e);
            return Option.none();
        }
    }
}

