/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servermetrics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.servermetrics.CheckpointTiming;
import com.google.common.base.MoreObjects;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;

@EventName(value="jira.http.request.stats")
@ParametersAreNonnullByDefault
public class RequestMetricsEvent {
    private final String url;
    private final Optional<String> requestKey;
    private final long reqTime;
    private final long requestUserTime;
    private final long requestCpuTime;
    private final long requestGCDuration;
    private final long requestGCCount;
    private final List<CheckpointTiming> checkpointReachTime;
    private final List<CheckpointTiming> activityTimings;
    private final Optional<String> requestCorrelationId;

    public RequestMetricsEvent(String url, Optional<String> requestKey, long reqTime, long requestUserTime, long requestCpuTime, long requestGCDuration, long requestGCCount, Optional<String> requestCorrelationId, List<CheckpointTiming> checkpointReachTimes, List<CheckpointTiming> activityTimings) {
        this.url = url;
        this.requestKey = requestKey;
        this.reqTime = reqTime;
        this.requestUserTime = requestUserTime;
        this.requestCpuTime = requestCpuTime;
        this.requestGCDuration = requestGCDuration;
        this.requestGCCount = requestGCCount;
        this.checkpointReachTime = checkpointReachTimes;
        this.requestCorrelationId = requestCorrelationId;
        this.activityTimings = activityTimings;
    }

    public String getKey() {
        return this.requestKey.orElse(null);
    }

    public String getUrl() {
        return this.url;
    }

    public long getReqTime() {
        return this.reqTime;
    }

    public Long getRequestUserTime() {
        return this.requestUserTime;
    }

    public long getRequestCpuTime() {
        return this.requestCpuTime;
    }

    public long getRequestGCDuration() {
        return this.requestGCDuration;
    }

    public long getRequestGCCount() {
        return this.requestGCCount;
    }

    public String getTimingEventKeys() {
        return this.checkpointReachTime.stream().map(CheckpointTiming::getCheckpointName).collect(Collectors.joining(","));
    }

    public String getTimingEventMillis() {
        return this.checkpointReachTime.stream().map(CheckpointTiming::getCheckpointTime).map(Duration::toMillis).map(String::valueOf).collect(Collectors.joining(","));
    }

    public Map<String, Long> getTimingEvents() {
        return this.checkpointReachTime.stream().collect(Collectors.toMap(CheckpointTiming::getCheckpointName, checkpointTiming -> checkpointTiming.getCheckpointTime().toMillis(), (existingValue, newValue) -> existingValue));
    }

    public Map<String, Long> getActivityTimings() {
        return this.activityTimings.stream().collect(Collectors.toMap(CheckpointTiming::getCheckpointName, checkpointTiming -> checkpointTiming.getCheckpointTime().toMillis(), (existingValue, newValue) -> existingValue));
    }

    public String getRequestCorrelationId() {
        return this.requestCorrelationId.orElse(null);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("url", (Object)this.url).add("key", this.requestKey).add("requestCorrelationId", this.requestCorrelationId).add("reqTime", this.reqTime).add("requestUserTime", this.requestUserTime).add("requestCpuTime", this.requestCpuTime).add("requestGCDuration", this.requestGCDuration).add("requestGCCount", this.requestGCCount).add("checkpointReachTime", this.checkpointReachTime).add("activityTimings", this.activityTimings).toString();
    }
}

