/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.analytics.start;

import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.archiving.ArchivedStatistics;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.service.services.analytics.JiraAnalyticTask;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class JiraBasicStatsAnalyticTask
implements JiraAnalyticTask {
    private OfBizDelegator ofBizDelegator;
    private ConstantsManager constantsManager;
    private VersionManager versionManager;
    private ProjectComponentManager componentManager;
    private IssueSecurityLevelManager levelManager;
    private FieldScreenManager screenManager;
    private FieldScreenSchemeManager screenSchemeManager;
    private ProjectManager projectManager;
    private ArchivedStatistics archivedStatistics;

    public JiraBasicStatsAnalyticTask() {
    }

    @VisibleForTesting
    JiraBasicStatsAnalyticTask(OfBizDelegator ofBizDelegator, ConstantsManager constantsManager, VersionManager versionManager, ProjectManager projectManager, ArchivedStatistics archivedStatistics, ProjectComponentManager componentManager, IssueSecurityLevelManager levelManager, FieldScreenManager screenManager, FieldScreenSchemeManager screenSchemeManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.constantsManager = constantsManager;
        this.versionManager = versionManager;
        this.projectManager = projectManager;
        this.archivedStatistics = archivedStatistics;
        this.componentManager = componentManager;
        this.levelManager = levelManager;
        this.screenManager = screenManager;
        this.screenSchemeManager = screenSchemeManager;
    }

    @Override
    public void init() {
        this.ofBizDelegator = ComponentAccessor.getOfBizDelegator();
        this.constantsManager = ComponentAccessor.getConstantsManager();
        this.versionManager = ComponentAccessor.getVersionManager();
        this.componentManager = ComponentAccessor.getProjectComponentManager();
        this.levelManager = ComponentAccessor.getIssueSecurityLevelManager();
        this.screenManager = ComponentAccessor.getFieldScreenManager();
        this.screenSchemeManager = (FieldScreenSchemeManager)ComponentAccessor.getComponent(FieldScreenSchemeManager.class);
        this.projectManager = ComponentAccessor.getProjectManager();
        this.archivedStatistics = (ArchivedStatistics)ComponentAccessor.getComponent(ArchivedStatistics.class);
    }

    @Override
    public Map<String, Object> getAnalytics() {
        MapBuilder builder = MapBuilder.newBuilder();
        builder.add((Object)"issues", (Object)this.ofBizDelegator.getCount("Issue"));
        builder.add((Object)"projects", (Object)this.ofBizDelegator.getCount("Project"));
        builder.add((Object)"comments", (Object)this.ofBizDelegator.getCount("Action"));
        builder.add((Object)"customfields", (Object)this.ofBizDelegator.getCount("CustomField"));
        builder.add((Object)"issuetypes", (Object)this.constantsManager.getAllIssueTypeIds().size());
        builder.add((Object)"status", (Object)this.size(this.constantsManager.getStatusObjects()));
        builder.add((Object)"resolutions", (Object)this.constantsManager.getResolutionObjects().size());
        builder.add((Object)"priorities", (Object)this.constantsManager.getPriorityObjects().size());
        builder.add((Object)"versions", (Object)this.size(this.versionManager.getAllVersions()));
        builder.add((Object)"components", (Object)this.size(this.componentManager.findAll()));
        builder.add((Object)"issuesecuritylevels", (Object)this.size(this.levelManager.getAllIssueSecurityLevels()));
        builder.add((Object)"screens", (Object)this.size(this.screenManager.getFieldScreens()));
        builder.add((Object)"screensschemes", (Object)this.size(this.screenSchemeManager.getFieldScreenSchemes()));
        builder.add((Object)"archivedissues", (Object)this.archivedStatistics.getTotalArchivedIssuesCount());
        builder.add((Object)"archivedprojects", (Object)this.projectManager.getArchivedProjects().size());
        builder.add((Object)"issuesinarchivedprojects", (Object)this.archivedStatistics.getIssuesInArchivedProjectsCount());
        builder.add((Object)"issuesarchivedindividually", (Object)this.archivedStatistics.getArchivedIssuesCount());
        this.buildPermissionSchemeInfo((MapBuilder<String, Object>)builder);
        return builder.toMap();
    }

    @Override
    public boolean isReportingDataShape() {
        return true;
    }

    private void buildPermissionSchemeInfo(MapBuilder<String, Object> builder) {
        List values = Select.columns("scheme", "count").from("PermissionSchemeCount").runWith(this.ofBizDelegator).asList();
        int permissions = values.size();
        long total = 0L;
        for (GenericValue value : values) {
            if (value.getString("scheme") == null) {
                --permissions;
                continue;
            }
            total += value.getLong("count").longValue();
        }
        builder.add((Object)"permission.scheme.avg", (Object)this.getAveragePermissionsForSchema(total, permissions));
        builder.add((Object)"permissionschemes", (Object)permissions);
    }

    private int getAveragePermissionsForSchema(long total, int permissions) {
        return permissions > 0 ? (int)total / permissions : 0;
    }

    private int size(Collection collection) {
        return collection != null ? collection.size() : 0;
    }
}

