/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.analytics.start;

import com.atlassian.jira.cache.HashRegistryCache;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.service.services.analytics.JiraAnalyticTask;
import com.atlassian.modzdetector.ModzRegistryException;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class ModifiedFilesAnalyticTask
implements JiraAnalyticTask {
    private HashRegistryCache registry;
    private static final String EMAIL_TEMPLATE_FILE_PATH = "templates/email";

    @Override
    public void init() {
        this.registry = (HashRegistryCache)ComponentAccessor.getComponent(HashRegistryCache.class);
    }

    @Override
    public Map<String, Object> getAnalytics() {
        return ImmutableMap.of((Object)"email.template.modified.count", (Object)this.modifiedEmailTemplates());
    }

    private Object modifiedEmailTemplates() {
        try {
            return this.registry.getModifications().modifiedFiles.stream().filter(file -> file.startsWith(EMAIL_TEMPLATE_FILE_PATH)).count();
        }
        catch (ModzRegistryException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Error while getting the number of modified email templates", (Throwable)e);
            return "unknown";
        }
    }

    @Override
    public boolean isReportingDataShape() {
        return false;
    }
}

