/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.UserShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.AbstractShareTypeValidator;
import com.atlassian.jira.sharing.type.ShareTypeValidator;
import com.atlassian.jira.sharing.type.UserShareType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nullable;

public class UserShareTypeValidator
extends AbstractShareTypeValidator
implements ShareTypeValidator {
    private final PermissionManager permissionManager;
    private final UserManager userManager;

    public UserShareTypeValidator(PermissionManager permissionManager, UserManager userManager) {
        this.permissionManager = permissionManager;
        this.userManager = userManager;
    }

    public boolean checkSearchParameter(JiraServiceContext ctx, ShareTypeSearchParameter searchParameter) {
        Assertions.notNull((String)"serviceCtx", (Object)ctx);
        Assertions.notNull((String)"SearchParameter", (Object)searchParameter);
        Assertions.equals((String)"type", (Object)searchParameter.getType(), (Object)UserShareType.TYPE);
        UserShareTypeSearchParameter userShareTypeSearchParameter = (UserShareTypeSearchParameter)searchParameter;
        String userKeyToBeSharedWith = userShareTypeSearchParameter.getUserKey();
        ApplicationUser userToBeSharedWith = this.userManager.getUserByKey(userKeyToBeSharedWith);
        return this.checkIfUserIsCorrect(userToBeSharedWith, userKeyToBeSharedWith, ctx) && !ctx.getErrorCollection().hasAnyErrors();
    }

    public boolean checkSharePermission(JiraServiceContext ctx, SharePermission permission) {
        Assertions.notNull((String)"serviceCtx", (Object)ctx);
        Assertions.notNull((String)"sharePermission", (Object)permission);
        Assertions.notNull((String)"serviceCtx.user", (Object)ctx.getLoggedInApplicationUser());
        Assertions.equals((String)"type", (Object)permission.getType(), (Object)UserShareType.TYPE);
        String userKeyToBeSharedWith = permission.getParam1();
        ApplicationUser userToBeSharedWith = this.userManager.getUserByKey(userKeyToBeSharedWith);
        if (!this.validateUsageContext(permission)) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.sharing.exception.invalid.usage.context.user", userKeyToBeSharedWith));
        }
        return this.currentUserHasPermissionToCreateShareObjects(ctx) && this.checkIfUserIsCorrect(userToBeSharedWith, userKeyToBeSharedWith, ctx) && !ctx.getErrorCollection().hasAnyErrors();
    }

    private boolean currentUserHasPermissionToCreateShareObjects(JiraServiceContext ctx) {
        boolean hasPermission = this.permissionManager.hasPermission(22, ctx.getLoggedInApplicationUser());
        if (!hasPermission) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.sharing.exception.no.share.permission"));
            return false;
        }
        return true;
    }

    private boolean checkIfUserIsCorrect(@Nullable ApplicationUser userToBeSharedWith, String userKeyToBeSharedWith, JiraServiceContext ctx) {
        if (userToBeSharedWith == null) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.sharing.exception.user.does.not.exist", userKeyToBeSharedWith));
            return false;
        }
        return true;
    }
}

