/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.config.webwork.WebworkConfigurator;
import com.atlassian.jira.health.HealthChecks;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentContainerLauncher {
    private static final Logger log = LoggerFactory.getLogger(ComponentContainerLauncher.class);

    public void start() {
        try {
            this.populateFullPicoContainer();
        }
        catch (RuntimeException rte) {
            log.error("A RuntimeException occurred during ComponentContainerLauncher servlet context initialisation - " + rte.getMessage() + ".", (Throwable)rte);
            throw rte;
        }
        catch (Error error) {
            log.error("An Error occurred during ComponentContainerLauncher servlet context initialisation - " + error.getMessage() + ".", (Throwable)error);
            throw error;
        }
    }

    private void populateFullPicoContainer() {
        if (JohnsonProvider.isStartupOk()) {
            try {
                ComponentManager componentManager = ComponentManager.getInstance();
                if (componentManager.getState().isContainerInitialised()) {
                    componentManager.shutdown();
                }
                componentManager.createFullContainer();
                WebworkConfigurator.setupConfiguration();
            }
            catch (Exception ex) {
                log.error("A fatal error occurred during initialisation. JIRA has been locked.", (Throwable)ex);
                HealthChecks.raiseFatalStartupProblem();
            }
        } else {
            log.error("Not initializing JIRA, the startup checklist failed and JIRA has been locked.");
        }
    }

    public void stop() {
        ComponentManager.getInstance().discardContainer();
    }
}

