/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class FormattedLogMsg {
    private static final String NEW_LINE = JiraSystemProperties.getInstance().getProperty("line.separator");
    private static final String INDENT_STR = "     ";
    private static final int MAX_DESC_WIDTH = 45;
    private static final int MAX_VALUE_WIDTH = 55;
    private static final int MAX_STAR_WIDTH = 200;
    private final Logger log;
    private final List<String> msgList = new ArrayList<String>();

    public FormattedLogMsg() {
        this(null);
    }

    public FormattedLogMsg(Logger log) {
        this.log = log;
    }

    public void add(Object message) {
        this.add(message, 0);
    }

    public void add(Object message, int indentLevel) {
        StringBuilder sb = new StringBuilder();
        if (indentLevel > 0) {
            String indentStr = StringUtils.repeat((String)INDENT_STR, (int)indentLevel);
            sb.append(indentStr);
        }
        sb.append(String.valueOf(message));
        this.msgList.add(sb.toString());
    }

    public void addAll(Collection<String> collection) {
        this.msgList.addAll(collection);
    }

    public void outputProperty(String propertyDesc) {
        this.outputPropertyImpl(propertyDesc, null, null, 1);
    }

    public void outputProperty(String propertyDesc, String propertyValue) {
        this.outputPropertyImpl(propertyDesc, propertyValue, null, 1);
    }

    public void outputProperty(String propertyDesc, String propertyValue, String splitStr) {
        this.outputPropertyImpl(propertyDesc, propertyValue, splitStr, 1);
    }

    public void outputProperty(String propertyDesc, String propertyValue, int indentLevel) {
        this.outputPropertyImpl(propertyDesc, propertyValue, null, indentLevel);
    }

    public void outputProperty(String propertyDesc, String propertyValue, String splitStr, int indentLevel) {
        this.outputPropertyImpl(propertyDesc, propertyValue, splitStr, indentLevel);
    }

    private void outputPropertyImpl(String propertyDesc, String propertyValue, String splitStr, int indentLevel) {
        int splitIndex;
        propertyDesc = propertyDesc == null ? "" : propertyDesc.trim();
        propertyValue = propertyValue == null ? "" : propertyValue.trim();
        String indentStr = StringUtils.repeat((String)INDENT_STR, (int)indentLevel);
        StringBuilder sb = new StringBuilder();
        sb.append(indentStr);
        sb.append(propertyDesc);
        int spacesLen = Math.max(45 - propertyDesc.length(), 0);
        sb.append(StringUtils.repeat((String)" ", (int)spacesLen));
        sb.append(" : ");
        int n = splitIndex = splitStr == null ? -1 : propertyValue.indexOf(splitStr);
        if (propertyValue.length() > 55 && splitIndex != -1) {
            String splitValue = this.indentValue(propertyValue, splitStr, true, indentLevel);
            sb.append(splitValue);
        } else {
            propertyValue = this.indentValue(propertyValue, NEW_LINE, false, indentLevel);
            sb.append(propertyValue);
        }
        this.msgList.add(sb.toString());
    }

    public void outputHeader(String header) {
        String prevMsg;
        boolean addNewLine;
        StringBuilder sb = new StringBuilder();
        boolean bl = addNewLine = !this.msgList.isEmpty();
        if (addNewLine && (prevMsg = String.valueOf(this.msgList.get(this.msgList.size() - 1))).equals(NEW_LINE)) {
            addNewLine = false;
        }
        if (addNewLine) {
            sb.append(NEW_LINE);
        }
        sb.append("___ ");
        sb.append(header);
        sb.append(" _");
        int spacesLen = Math.max(45 - sb.length(), 0);
        sb.append(StringUtils.repeat((String)"_", (int)spacesLen));
        sb.append(NEW_LINE);
        this.msgList.add(sb.toString());
    }

    private String indentValue(String propertyValue, String splitStr, boolean reappendSplitStr, int indentlevel) {
        int splitIndex = propertyValue.indexOf(splitStr);
        if (splitIndex == -1) {
            return propertyValue;
        }
        int lastIndex = 0;
        String indentStr = StringUtils.repeat((String)INDENT_STR, (int)indentlevel);
        StringBuilder sb = new StringBuilder();
        while (splitIndex != -1) {
            int splitStrLen = splitStr.length();
            String splitValue = propertyValue.substring(lastIndex, splitIndex);
            if (lastIndex > 0) {
                sb.append(NEW_LINE);
                sb.append(indentStr);
                sb.append(StringUtils.repeat((String)" ", (int)45));
                sb.append("   ");
            }
            sb.append(splitValue);
            if (reappendSplitStr) {
                sb.append(splitStr);
            }
            lastIndex = splitIndex + splitStrLen;
            splitIndex = propertyValue.indexOf(splitStr, lastIndex);
        }
        if (lastIndex < propertyValue.length()) {
            String splitValue = propertyValue.substring(lastIndex);
            sb.append(NEW_LINE);
            sb.append(indentStr);
            sb.append(StringUtils.repeat((String)" ", (int)45));
            sb.append("   ");
            sb.append(splitValue);
        }
        return sb.toString();
    }

    public void printMessage(Level logLevel) {
        this.printMessageImpl(this.msgList, logLevel, true);
    }

    public void printMessage(Level logLevel, boolean useStars) {
        this.printMessageImpl(this.msgList, logLevel, useStars);
    }

    private void printMessageImpl(Collection<String> messages, Level logLevel, boolean useStars) {
        String line = this.toStringImpl(messages, useStars);
        if (this.log != null) {
            this.log.log((Priority)logLevel, (Object)line);
        }
        this.resetState();
    }

    public String toString() {
        return this.toStringImpl(this.msgList, false);
    }

    private String toStringImpl(Collection<String> messages, boolean useStars) {
        if (messages == null || messages.isEmpty()) {
            return "";
        }
        int maxLength = 0;
        for (String message : messages) {
            maxLength = Math.max(message.length(), maxLength);
            maxLength = Math.min(200, maxLength);
        }
        StringBuilder line = new StringBuilder().append(NEW_LINE).append(NEW_LINE);
        if (useStars) {
            line.append(StringUtils.repeat((String)"*", (int)maxLength)).append(NEW_LINE);
        }
        for (String message : messages) {
            line.append(message).append(NEW_LINE);
        }
        if (useStars) {
            line.append(StringUtils.repeat((String)"*", (int)maxLength)).append(NEW_LINE);
        }
        return line.toString();
    }

    private void resetState() {
        this.msgList.clear();
    }
}

