/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.upgrade.UpgradeResult;
import com.atlassian.jira.upgrade.UpgradeScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedUpgradeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelayedUpgradeService.class);
    private static final int DEFAULT_DELAY_IN_MINUTES = 1;
    private final UpgradeScheduler upgradeScheduler;
    private final ApplicationProperties applicationProperties;

    public DelayedUpgradeService(UpgradeScheduler upgradeScheduler, ApplicationProperties applicationProperties) {
        this.upgradeScheduler = upgradeScheduler;
        this.applicationProperties = applicationProperties;
    }

    public UpgradeResult scheduleUpgrades() {
        if (this.applicationProperties.getOption("jira.upgrade.force.manual.schedule")) {
            LOGGER.info("Upgrades not scheduled, {}=true", (Object)"jira.upgrade.force.manual.schedule");
            return UpgradeResult.OK;
        }
        return this.upgradeScheduler.scheduleUpgrades(this.getDelayInMinutes());
    }

    private int getDelayInMinutes() {
        String delay = this.applicationProperties.getDefaultBackedString("jira.upgrade.delay.minutes");
        try {
            return Integer.valueOf(delay);
        }
        catch (NumberFormatException ignore) {
            LOGGER.warn("{} property value {} is not an integer", (Object)"jira.upgrade.delay.minutes", (Object)delay);
            LOGGER.warn("Using default value {} for {} property ", (Object)1, (Object)"jira.upgrade.delay.minutes");
            return 1;
        }
    }
}

