/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.bc.dataimport.DowngradeUtil;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.ReindexRequestManager;
import com.atlassian.jira.index.request.ReindexRequestType;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.upgrade.ReindexRequirement;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DowngradeReindexLauncher {
    private static final Logger log = LoggerFactory.getLogger(DowngradeReindexLauncher.class);

    public void start() {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        if ("true".equals(applicationProperties.getString("jira.setup")) && JohnsonProvider.isStartupOk()) {
            this.requestReindexIfRequired(applicationProperties);
        }
    }

    private void requestReindexIfRequired(ApplicationProperties applicationProperties) {
        boolean runInBackground;
        ReindexRequirement reindexRequirement = DowngradeUtil.getReindexRequirement(applicationProperties);
        switch (reindexRequirement) {
            case NONE: {
                return;
            }
            case BACKGROUND: {
                runInBackground = true;
                log.info("Downgrade tasks have triggered a background reindex.");
                break;
            }
            case FOREGROUND: {
                runInBackground = false;
                log.info("Downgrade tasks have triggered a foreground reindex.");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ReindexRequestManager reindexRequestManager = (ReindexRequestManager)ComponentAccessor.getComponent(ReindexRequestManager.class);
        reindexRequestManager.requestReindex(ReindexRequestType.IMMEDIATE, EnumSet.allOf(AffectedIndex.class), EnumSet.allOf(SharedEntityType.class));
        reindexRequestManager.processPendingRequests(!runInBackground, EnumSet.of(ReindexRequestType.IMMEDIATE), runInBackground);
        if (runInBackground) {
            log.info("Background reindex has been started.");
        } else {
            log.info("Full foreground reindex complete.");
        }
        DowngradeUtil.setReindexRequirement(applicationProperties, ReindexRequirement.NONE);
    }
}

