/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.util.xml.XmlNode;
import com.atlassian.security.xml.SecureXmlParserFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DowngradeTaskFileParser {
    public Collection<String> parse(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory docBuilderFactory = SecureXmlParserFactory.newDocumentBuilderFactory();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(inputStream);
        XmlNode docNode = new XmlNode(doc);
        return this.parseDowngrades(docNode.getFirstChild("downgrades"));
    }

    private Collection<String> parseDowngrades(XmlNode downgradesNode) {
        List<XmlNode> downgradeNodes = downgradesNode.getChildren("downgrade");
        ArrayList<String> downgradesList = new ArrayList<String>(downgradeNodes.size());
        for (XmlNode downgradeNode : downgradeNodes) {
            String downgradeTask = this.parseDowngradeTask(downgradeNode);
            downgradesList.add(downgradeTask);
        }
        return downgradesList;
    }

    private String parseDowngradeTask(XmlNode downgradeNode) {
        XmlNode child = downgradeNode.getFirstChild("class");
        if (child == null) {
            throw new IllegalStateException("Downgrade task XML config file is in an invalid state.");
        }
        return child.getTextContent();
    }
}

