/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.google.common.collect.ImmutableSet;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropIndexHelper {
    private static final Logger log = LoggerFactory.getLogger(DropIndexHelper.class);
    private final String MISSING_INDEX = "Index %s on table %s was destined to be removed, but doesn't exist";
    private final String TABLE_DOES_NOT_EXIST = "Table %s does not exist";
    private final AbstractUpgradeTask abstractUpgradeTask;

    public DropIndexHelper(AbstractUpgradeTask abstractUpgradeTask) {
        this.abstractUpgradeTask = abstractUpgradeTask;
    }

    protected String buildDropIndexSql(String tableName, String index) {
        return this.abstractUpgradeTask.getDatabaseType().getDropIndexSQL(this.abstractUpgradeTask.getSchemaName(), tableName, index);
    }

    public void dropIndex(String tableName, String indexName) throws SQLException {
        if (!this.checkIndexExists(tableName, indexName)) {
            log.warn(String.format("Index %s on table %s was destined to be removed, but doesn't exist", indexName, tableName));
            return;
        }
        try (Connection connection = this.abstractUpgradeTask.getDatabaseConnection();){
            connection.setAutoCommit(false);
            Statement update = connection.createStatement();
            update.execute(this.buildDropIndexSql(tableName, indexName));
            connection.commit();
        }
        catch (SQLException e) {
            log.error(String.format("Index drop for %s.%s failed. Please remove it manually.", tableName, indexName));
            throw e;
        }
    }

    public boolean checkIndexExists(String tableName, String indexName) {
        DatabaseUtil databaseUtil = this.abstractUpgradeTask.getDatabaseUtil();
        LinkedList messages = new LinkedList();
        ImmutableSet tables = ImmutableSet.of((Object)tableName);
        Map indexInfo = databaseUtil.getIndexInfo((Set)tables, messages);
        if (!messages.isEmpty()) {
            throw new DataAccessException(String.join((CharSequence)" ", messages));
        }
        if (!indexInfo.containsKey(tableName)) {
            throw new IllegalArgumentException(String.format("Table %s does not exist", tableName));
        }
        Set indexes = (Set)indexInfo.get(tableName);
        log.debug(indexes.stream().collect(Collectors.joining(", ", String.format("Table %s contains indexes: ", tableName), "")));
        return indexes.contains(indexName.toUpperCase());
    }
}

