/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.IssueInvolvement;
import com.atlassian.jira.user.UserIssueRelevance;
import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.SortedSet;
import org.springframework.util.Assert;

public class ImmutableUserIssueRelevance
implements UserIssueRelevance {
    private final ApplicationUser user;
    private final Issue issue;
    private final ImmutableSortedSet<IssueInvolvement> issueInvolvements;
    private final Optional<Integer> highestIssueInvolvementRank;
    private final Optional<Date> latestCommentCreationTime;

    private ImmutableUserIssueRelevance(ApplicationUser user, Issue issue, ImmutableSortedSet<IssueInvolvement> issueInvolvements, Date latestCommentCreationTime) {
        this.user = user;
        this.issue = issue;
        this.issueInvolvements = issueInvolvements;
        this.highestIssueInvolvementRank = issueInvolvements.isEmpty() ? Optional.empty() : Optional.of(((IssueInvolvement)issueInvolvements.first()).ordinal());
        this.latestCommentCreationTime = Optional.ofNullable(latestCommentCreationTime);
    }

    @Override
    public ApplicationUser getUser() {
        return this.user;
    }

    @Override
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public SortedSet<IssueInvolvement> getIssueInvolvements() {
        return this.issueInvolvements;
    }

    @Override
    public Optional<Integer> getHighestIssueInvolvementRank() {
        return this.highestIssueInvolvementRank;
    }

    @Override
    public Optional<Date> getLatestCommentCreationTime() {
        return this.latestCommentCreationTime;
    }

    @Override
    public int compareTo(UserIssueRelevance o) {
        Assert.isTrue((boolean)this.getIssue().equals((Object)o.getIssue()), (String)"UserIssueRelevance's can only be compared if they share the same issue.");
        int result = this.compareOptionals(this.getHighestIssueInvolvementRank(), o.getHighestIssueInvolvementRank(), Integer::compareTo);
        if (result == 0) {
            result = -this.compareOptionals(this.getLatestCommentCreationTime(), o.getLatestCommentCreationTime(), Date::compareTo);
        }
        if (result == 0) {
            result = this.getUser().getDisplayName().compareTo(o.getUser().getDisplayName());
        }
        return result;
    }

    private <T> int compareOptionals(Optional<T> a, Optional<T> b, Comparator<T> comparator) {
        if (a.isPresent()) {
            return b.isPresent() ? comparator.compare(a.get(), b.get()) : -1;
        }
        return b.isPresent() ? 1 : 0;
    }

    public static class IssueUserBuilder {
        private ApplicationUser user;
        private Issue issue;
        private final HashSet<IssueInvolvement> issueInvolvements = new HashSet();
        private Date latestCommentCreationTime;

        public IssueUserBuilder withUser(ApplicationUser user) {
            this.user = user;
            return this;
        }

        public IssueUserBuilder withIssue(Issue issue) {
            this.issue = issue;
            return this;
        }

        public IssueUserBuilder withAssigneeInvolvement() {
            this.issueInvolvements.add(IssueInvolvement.ASSIGNEE);
            return this;
        }

        public IssueUserBuilder withReporterInvolvement() {
            this.issueInvolvements.add(IssueInvolvement.REPORTER);
            return this;
        }

        public IssueUserBuilder withCommenterInvolvement(Date latestCommentCreationTime) {
            this.issueInvolvements.add(IssueInvolvement.COMMENTER);
            this.latestCommentCreationTime = latestCommentCreationTime;
            return this;
        }

        public IssueUserBuilder withWatcherInvolvement() {
            this.issueInvolvements.add(IssueInvolvement.WATCHER);
            return this;
        }

        public IssueUserBuilder withVoterInvolvement() {
            this.issueInvolvements.add(IssueInvolvement.VOTER);
            return this;
        }

        public UserIssueRelevance build() {
            return new ImmutableUserIssueRelevance(this.user, this.issue, ImmutableSortedSet.copyOf(this.issueInvolvements), this.latestCommentCreationTime);
        }
    }
}

