/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.event.user.anonymize.UserAnonymizationFinishedEvent;
import com.atlassian.jira.event.user.anonymize.UserAnonymizationStartedEvent;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.ServiceOutcomeWithWarnings;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ExperimentalApi
public interface AnonymizeUserService {
    @Nonnull
    public AnonymizeValidationResult preValidateAnonymize(@Nonnull AnonymizeUserRequest var1);

    @Nonnull
    public AnonymizeValidationResult validateAnonymize(@Nonnull AnonymizeUserRequest var1);

    @Nonnull
    public AnonymizePerformResult perform(@Nonnull AnonymizeValidationResult var1, @Nonnull Context var2);

    public int getStepCount(@Nonnull AnonymizeValidationResult var1);

    public static class AnonymizeValidationResult
    extends ServiceResultImpl {
        private final AnonymizeUserRequest request;
        private final AnonymizeProcessData processData;
        private final OperationsReport<Collection<AffectedEntity>> affectedEntitiesReport;
        private final OperationsReport<Void> operationValidation;

        public AnonymizeValidationResult(@Nonnull ErrorCollection errors, @Nonnull AnonymizeUserRequest request, @Nullable AnonymizeProcessData processData, @Nonnull OperationsReport<Collection<AffectedEntity>> affectedEntitiesReport, @Nonnull OperationsReport<Void> operationValidation) {
            super(errors);
            this.request = Objects.requireNonNull(request);
            this.processData = processData;
            this.affectedEntitiesReport = affectedEntitiesReport;
            this.operationValidation = Objects.requireNonNull(operationValidation);
        }

        @Nonnull
        public AnonymizeUserRequest getRequest() {
            return this.request;
        }

        @Nullable
        public AnonymizeProcessData getProcessData() {
            return this.processData;
        }

        @Nonnull
        public OperationsReport<Void> getOperationValidation() {
            return this.operationValidation;
        }

        @Nonnull
        public OperationsReport<Collection<AffectedEntity>> getAffectedEntitiesReport() {
            return this.affectedEntitiesReport;
        }

        public boolean isValid() {
            return super.isValid() && this.affectedEntitiesReport.isValid() && this.operationValidation.isValid();
        }
    }

    public static class AnonymizePerformResult
    implements Serializable {
        private final AnonymizeUserRequest request;
        private final transient AnonymizeProcessData processData;
        private final OperationsReport<Void> report;

        public AnonymizePerformResult(AnonymizeUserRequest request, AnonymizeProcessData processData, OperationsReport<Void> report) {
            this.request = request;
            this.processData = processData;
            this.report = report;
        }

        public AnonymizeUserRequest getRequest() {
            return this.request;
        }

        public AnonymizeProcessData getProcessData() {
            return this.processData;
        }

        public OperationsReport<Void> getReport() {
            return this.report;
        }
    }

    public static class OperationsReport<T>
    implements Serializable {
        private Map<AnonymizeOperation, SingleOperationReport<T>> reportMap = new EnumMap<AnonymizeOperation, SingleOperationReport<T>>(AnonymizeOperation.class);

        @Nonnull
        public Optional<SingleOperationReport<T>> getReport(@Nonnull AnonymizeOperation operation) {
            return Optional.ofNullable(this.reportMap.get((Object)operation));
        }

        public void putReport(@Nonnull SingleOperationReport<T> report) {
            this.reportMap.put(report.getOperation(), report);
        }

        public boolean isValid() {
            return this.reportMap.values().stream().allMatch(SingleOperationReport::isValid);
        }

        public boolean isEmpty() {
            return this.reportMap.isEmpty();
        }

        public Collection<SingleOperationReport<T>> getReports() {
            return ImmutableList.copyOf(this.reportMap.values());
        }

        public Collection<AnonymizeOperation> getOperations() {
            return ImmutableList.copyOf(this.reportMap.keySet());
        }

        public String toString() {
            return "OperationsReport{reportMap=" + this.reportMap + '}';
        }
    }

    public static class SingleOperationReport<T>
    implements Serializable {
        private final AnonymizeOperation operation;
        private final ServiceOutcomeWithWarnings<T> result;

        public SingleOperationReport(@Nonnull AnonymizeOperation operation, @Nonnull ServiceOutcomeWithWarnings<T> result) {
            this.operation = Objects.requireNonNull(operation);
            this.result = Objects.requireNonNull(result);
        }

        @Nonnull
        public AnonymizeOperation getOperation() {
            return this.operation;
        }

        @Nonnull
        public ServiceOutcomeWithWarnings<T> getResult() {
            return this.result;
        }

        public boolean isValid() {
            return this.result.isValid();
        }

        public String toString() {
            return "SingleOperationReport{operation=" + (Object)((Object)this.operation) + ", result=" + this.result + '}';
        }
    }

    public static enum UserState {
        NOT_FOUND,
        DELETED,
        PRESENT;

    }

    public static enum AnonymizeOperation {
        USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS,
        USER_DISABLE,
        USER_KEY_CHANGE_PLUGIN_POINTS,
        USER_KEY_CHANGE,
        USER_NAME_CHANGE_PLUGIN_POINTS,
        USER_NAME_CHANGE,
        USER_EXTERNAL_ID_CHANGE,
        USER_ANONYMIZE_PLUGIN_POINTS;

    }

    public static class AnonymizeProcessData {
        private final AnonymizeUserRequest anonymizeUserRequest;
        private final ApplicationUser user;
        private final boolean userDeletedExternally;
        private final boolean userNameAlreadyAnonymized;
        private final boolean userKeyAlreadyAnonymized;
        private final String newUserName;
        private final String newUserKey;
        private final Collection<AffectedEntity> affectedEntities;

        public AnonymizeProcessData(@Nonnull AnonymizeUserRequest anonymizeUserRequest, @Nullable ApplicationUser user, boolean userDeletedExternally, boolean userNameAlreadyAnonymized, boolean userKeyAlreadyAnonymized, @Nullable String newUserName, @Nullable String newUserKey, @Nonnull Collection<AffectedEntity> affectedEntities) {
            this.anonymizeUserRequest = anonymizeUserRequest;
            this.user = user;
            this.userDeletedExternally = userDeletedExternally;
            this.userNameAlreadyAnonymized = userNameAlreadyAnonymized;
            this.userKeyAlreadyAnonymized = userKeyAlreadyAnonymized;
            this.newUserName = newUserName;
            this.newUserKey = newUserKey;
            this.affectedEntities = affectedEntities;
        }

        private AnonymizeProcessData(Builder builder) {
            this.anonymizeUserRequest = builder.anonymizeUserRequest;
            this.user = builder.user;
            this.userDeletedExternally = builder.userDeletedExternally;
            this.userNameAlreadyAnonymized = builder.userNameAlreadyAnonymized;
            this.userKeyAlreadyAnonymized = builder.userKeyAlreadyAnonymized;
            this.newUserName = builder.newUserName;
            this.newUserKey = builder.newUserKey;
            this.affectedEntities = builder.affectedEntities;
        }

        public static Builder newBuilder(@Nonnull AnonymizeUserRequest anonymizeUserRequest) {
            return new Builder(anonymizeUserRequest);
        }

        public AnonymizeUserRequest getAnonymizeUserRequest() {
            return this.anonymizeUserRequest;
        }

        public boolean handleOperation(AnonymizeOperation anonymizeOperation) {
            if (this.user == null) {
                return false;
            }
            return this.getOperationsWeWouldLikeToPerform(false).contains((Object)anonymizeOperation);
        }

        public Collection<AnonymizeOperation> getOperationsWeWouldLikeToPerform(boolean preValidate) {
            ImmutableSet.Builder operations = ImmutableSet.builder();
            if (this.user == null) {
                return operations.build();
            }
            if (preValidate) {
                if (this.isUserActive() || this.userDeletedExternally) {
                    operations.add((Object)AnonymizeOperation.USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS);
                }
            } else if (this.isRequiresTransferOwner()) {
                operations.add((Object)AnonymizeOperation.USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS);
            }
            if (this.isUserActive()) {
                operations.add((Object)AnonymizeOperation.USER_DISABLE);
            }
            if (this.getUserState() == UserState.PRESENT) {
                operations.add((Object)AnonymizeOperation.USER_EXTERNAL_ID_CHANGE);
            }
            operations.add((Object)AnonymizeOperation.USER_ANONYMIZE_PLUGIN_POINTS);
            if (!this.userKeyAlreadyAnonymized) {
                operations.add((Object)AnonymizeOperation.USER_KEY_CHANGE);
            }
            if (!this.userKeyAlreadyAnonymized || this.userKeyAnonymizedButRerunPluginPointsRequested()) {
                operations.add((Object)AnonymizeOperation.USER_KEY_CHANGE_PLUGIN_POINTS);
            }
            if (!this.userNameAlreadyAnonymized) {
                operations.add((Object)AnonymizeOperation.USER_NAME_CHANGE);
            }
            if (!this.userNameAlreadyAnonymized || this.userNameAnonymizedButRerunPluginPointsRequested()) {
                operations.add((Object)AnonymizeOperation.USER_NAME_CHANGE_PLUGIN_POINTS);
            }
            return operations.build();
        }

        public boolean userNameAnonymizedButRerunPluginPointsRequested() {
            return this.userNameAlreadyAnonymized && this.anonymizeUserRequest.isRerunPluginPoints();
        }

        private boolean userKeyAnonymizedButRerunPluginPointsRequested() {
            return this.userKeyAlreadyAnonymized && this.anonymizeUserRequest.isRerunPluginPoints();
        }

        public boolean isRequiresTransferOwner() {
            return this.affectedEntities.stream().anyMatch(affectedEntity -> affectedEntity.getType() == AffectedEntityType.TRANSFER_OWNERSHIP);
        }

        @Nullable
        public ApplicationUser getUser() {
            return this.user;
        }

        public UserState getUserState() {
            if (this.user == null) {
                return UserState.NOT_FOUND;
            }
            if (this.user.getDirectoryId() == -1L) {
                if (this.user.getId().equals(-1L)) {
                    return UserState.NOT_FOUND;
                }
                return UserState.DELETED;
            }
            return UserState.PRESENT;
        }

        public boolean isUserDeletedExternally() {
            return this.userDeletedExternally;
        }

        public boolean isUserNameAlreadyAnonymized() {
            return this.userNameAlreadyAnonymized;
        }

        public boolean isUserKeyAlreadyAnonymized() {
            return this.userKeyAlreadyAnonymized;
        }

        @Nullable
        public String getNewUserName() {
            return this.newUserName;
        }

        @Nullable
        public String getNewUserKey() {
            return this.newUserKey;
        }

        @Nullable
        public String getOldUserName() {
            return this.anonymizeUserRequest.getOldUserName();
        }

        @Nullable
        public String getOldUserKey() {
            return this.anonymizeUserRequest.getOldUserKey();
        }

        public String getTransferOwnerKey() {
            return this.anonymizeUserRequest.getNewOwnerKey();
        }

        public Collection<AffectedEntity> getAffectedEntities() {
            return this.affectedEntities;
        }

        private boolean isUserActive() {
            return Optional.ofNullable(this.user).map(ApplicationUser::isActive).orElse(false);
        }

        @Nonnull
        public UserAnonymizationStartedEvent getUserAnonymizationStartedEvent() {
            if (this.user == null) {
                throw new IllegalStateException();
            }
            return new UserAnonymizationStartedEvent(this.user.getKey(), this.user.getUsername());
        }

        @Nonnull
        public UserAnonymizationFinishedEvent getUserAnonymizationFinishedEvent() {
            if (this.user == null) {
                throw new IllegalStateException();
            }
            String userKey = this.user.getKey();
            String userName = this.user.getUsername();
            String oldUserKey = this.user.getKey();
            String oldUserName = this.user.getUsername();
            if (this.getOperationsWeWouldLikeToPerform(false).contains((Object)AnonymizeOperation.USER_KEY_CHANGE)) {
                userKey = this.newUserKey;
                if (this.getAnonymizeUserRequest().isRerunPluginPoints()) {
                    oldUserKey = this.getAnonymizeUserRequest().getOldUserKey();
                }
            }
            if (this.getOperationsWeWouldLikeToPerform(false).contains((Object)AnonymizeOperation.USER_NAME_CHANGE)) {
                userName = this.newUserName;
                if (this.getAnonymizeUserRequest().isRerunPluginPoints()) {
                    oldUserName = this.getAnonymizeUserRequest().getOldUserName();
                }
            }
            return new UserAnonymizationFinishedEvent(userKey, userName, oldUserKey, oldUserName);
        }

        public static final class Builder {
            private AnonymizeUserRequest anonymizeUserRequest;
            private ApplicationUser user;
            private boolean userDeletedExternally;
            private boolean userNameAlreadyAnonymized;
            private boolean userKeyAlreadyAnonymized;
            private String newUserName;
            private String newUserKey;
            private Collection<AffectedEntity> affectedEntities = Collections.emptyList();

            private Builder(@Nonnull AnonymizeUserRequest anonymizeUserRequest) {
                this.anonymizeUserRequest = Objects.requireNonNull(anonymizeUserRequest);
            }

            public Builder user(@Nullable ApplicationUser user) {
                this.user = user;
                return this;
            }

            public Builder userDeletedExternally(boolean userDeletedExternally) {
                this.userDeletedExternally = userDeletedExternally;
                return this;
            }

            public Builder userNameAlreadyAnonymized(boolean userNameAlreadyAnonymized) {
                this.userNameAlreadyAnonymized = userNameAlreadyAnonymized;
                return this;
            }

            public Builder userKeyAlreadyAnonymized(boolean userKeyAlreadyAnonymized) {
                this.userKeyAlreadyAnonymized = userKeyAlreadyAnonymized;
                return this;
            }

            public Builder newUserName(String newUserName) {
                this.newUserName = newUserName;
                return this;
            }

            public Builder newUserKey(String newUserKey) {
                this.newUserKey = newUserKey;
                return this;
            }

            public Builder affectedEntities(Collection<AffectedEntity> affectedEntities) {
                this.affectedEntities = affectedEntities;
                return this;
            }

            public AnonymizeProcessData build() {
                return new AnonymizeProcessData(this);
            }
        }
    }

    public static class AnonymizeUserRequest
    implements Serializable {
        private final String userKey;
        private final boolean rerunPluginPoints;
        private final String oldUserKey;
        private final String oldUserName;
        private final String newOwnerKey;
        private final transient ApplicationUser executor;

        private AnonymizeUserRequest(@Nonnull String userKey, boolean rerunPluginPoints, @Nullable String oldUserKey, @Nullable String oldUserName, @Nullable String newOwnerKey, @Nonnull ApplicationUser executor) {
            this.userKey = (String)Preconditions.checkNotNull((Object)userKey);
            this.rerunPluginPoints = rerunPluginPoints;
            this.oldUserKey = oldUserKey;
            this.oldUserName = oldUserName;
            this.newOwnerKey = newOwnerKey;
            this.executor = (ApplicationUser)Preconditions.checkNotNull((Object)executor);
        }

        public static Builder builder() {
            return new Builder();
        }

        @Nonnull
        public String getUserKey() {
            return this.userKey;
        }

        public boolean isRerunPluginPoints() {
            return this.rerunPluginPoints;
        }

        @Nullable
        public String getNewOwnerKey() {
            return this.newOwnerKey;
        }

        @Nonnull
        public ApplicationUser getExecutor() {
            return this.executor;
        }

        @Nullable
        public String getOldUserKey() {
            return this.oldUserKey;
        }

        @Nullable
        public String getOldUserName() {
            return this.oldUserName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnonymizeUserRequest that = (AnonymizeUserRequest)o;
            return this.rerunPluginPoints == that.rerunPluginPoints && Objects.equals(this.userKey, that.userKey) && Objects.equals(this.oldUserKey, that.oldUserKey) && Objects.equals(this.oldUserName, that.oldUserName) && Objects.equals(this.newOwnerKey, that.newOwnerKey) && Objects.equals(this.executor, that.executor);
        }

        public int hashCode() {
            return Objects.hash(this.userKey, this.rerunPluginPoints, this.oldUserKey, this.oldUserName, this.newOwnerKey, this.executor);
        }

        public String toString() {
            return "AnonymizeUserRequest{userKey='" + this.userKey + '\'' + ", rerunPluginPoints=" + this.rerunPluginPoints + ", oldUserKey='" + this.oldUserKey + '\'' + ", oldUserName='" + this.oldUserName + '\'' + ", newOwnerKey=" + this.newOwnerKey + ", executor=" + this.executor + '}';
        }

        public static class Builder {
            private String userKey;
            private boolean rerunPluginPoints;
            private String oldUserKey;
            private String oldUserName;
            private String newOwnerKey;
            private ApplicationUser executor;

            public Builder targetUser(@Nonnull String userKey) {
                this.userKey = Objects.requireNonNull(userKey);
                return this;
            }

            public Builder rerunPluginPoints(boolean rerunPluginPoints) {
                this.rerunPluginPoints = rerunPluginPoints;
                return this;
            }

            public Builder newOwnerKey(@Nullable String newOwnerKey) {
                this.newOwnerKey = newOwnerKey;
                return this;
            }

            public Builder executor(@Nonnull ApplicationUser executor) {
                this.executor = Objects.requireNonNull(executor);
                return this;
            }

            public Builder oldUserKey(@Nullable String oldUserKey) {
                this.oldUserKey = oldUserKey;
                return this;
            }

            public Builder oldUserName(@Nullable String oldUserName) {
                this.oldUserName = oldUserName;
                return this;
            }

            public AnonymizeUserRequest build() {
                return new AnonymizeUserRequest(this.userKey, this.rerunPluginPoints, this.oldUserKey, this.oldUserName, this.newOwnerKey, this.executor);
            }
        }
    }
}

