/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AnonymizationHandler;
import com.atlassian.jira.user.anonymize.AnonymizationHandlerModuleDescriptor;
import com.atlassian.jira.user.anonymize.TaskContextAware;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.PluginAccessor;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserPropertyChangeManager<T extends AnonymizationHandler<P>, P extends TaskContextAware> {
    private static Logger log = LoggerFactory.getLogger(UserPropertyChangeManager.class);
    private final PluginAccessor pluginAccessor;

    public UserPropertyChangeManager(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public abstract void changeProperty(@Nonnull P var1);

    protected abstract Class<? extends AnonymizationHandlerModuleDescriptor<T, P>> getModuleDescriptorClass();

    @Nonnull
    public Map<AnonymizationHandlerModuleDescriptor, ServiceOutcome<Collection<AffectedEntity>>> getAffectedEntities(@Nonnull P parameter) {
        HashMap<AnonymizationHandlerModuleDescriptor, ServiceOutcome<Collection<AffectedEntity>>> response = new HashMap<AnonymizationHandlerModuleDescriptor, ServiceOutcome<Collection<AffectedEntity>>>();
        List<AnonymizationHandlerModuleDescriptor<T, P>> handlers = this.getModuleDescriptorsForHandlers();
        log.info("User property change handlers count: {}", (Object)handlers.size());
        for (AnonymizationHandlerModuleDescriptor<T, P> handlerModuleDescriptor : handlers) {
            response.put(handlerModuleDescriptor, this.getAffectedEntitiesFromHandler(handlerModuleDescriptor, parameter));
        }
        return response;
    }

    @Nonnull
    public Map<AnonymizationHandlerModuleDescriptor, ServiceResult> executeHandlers(@Nonnull P parameter, @Nonnull I18nHelper i18nBean) {
        HashMap<AnonymizationHandlerModuleDescriptor, ServiceResult> response = new HashMap<AnonymizationHandlerModuleDescriptor, ServiceResult>();
        List<AnonymizationHandlerModuleDescriptor<T, P>> handlers = this.getModuleDescriptorsForHandlers();
        log.info("User property change handlers count: {}", (Object)handlers.size());
        for (AnonymizationHandlerModuleDescriptor<T, P> handlerModuleDescriptor : handlers) {
            response.put(handlerModuleDescriptor, this.executeHandler(handlerModuleDescriptor, parameter, i18nBean));
        }
        return response;
    }

    int getNumberOfTasks(@Nonnull P userPropertyChangeParameter) {
        return this.getModuleDescriptorsForHandlers().stream().map(AbstractJiraModuleDescriptor::getModule).mapToInt(module -> module.getNumberOfTasks(userPropertyChangeParameter)).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected ServiceOutcome<Collection<AffectedEntity>> getAffectedEntitiesFromHandler(@Nonnull AnonymizationHandlerModuleDescriptor<T, P> handlerModuleDescriptor, @Nonnull P userPropertyChangeParameter) {
        AnonymizationHandler handler = (AnonymizationHandler)handlerModuleDescriptor.getModule();
        log.info("Getting affected entities for handler: {}", handlerModuleDescriptor);
        try {
            Collection affectedEntities = this.retryOnException(() -> handler.getAffectedEntities(userPropertyChangeParameter), 1);
            ServiceOutcomeImpl<Collection<AffectedEntity>> serviceOutcomeImpl = ServiceOutcomeImpl.ok(affectedEntities);
            return serviceOutcomeImpl;
        }
        catch (Exception e) {
            log.error("Exception during getting affected entities {}", handlerModuleDescriptor, (Object)e);
            ServiceOutcomeImpl<Collection<AffectedEntity>> serviceOutcomeImpl = ServiceOutcomeImpl.error(e.getMessage());
            return serviceOutcomeImpl;
        }
        finally {
            log.info("Ending getting affected entities for handler: {}", handlerModuleDescriptor);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    protected ServiceResult executeHandler(@Nonnull AnonymizationHandlerModuleDescriptor<T, P> handlerModuleDescriptor, @Nonnull P userPropertyChangeParameter, @Nonnull I18nHelper i18nBean) {
        AnonymizationHandler handler = (AnonymizationHandler)handlerModuleDescriptor.getModule();
        log.info("Starting task for handler: {}", handlerModuleDescriptor);
        Context taskContext = userPropertyChangeParameter.getContext();
        try (Context.Task task = taskContext.start((Object)handler);){
            taskContext.setName(i18nBean.getText("admin.user.property.change.processing.handler", handlerModuleDescriptor.getDisplayName()));
            ServiceResult handlerResponse = this.retryOnException(() -> handler.update(userPropertyChangeParameter), 1);
            if (!handlerResponse.isValid()) {
                log.info("Ending task (error) for handler: {}, ({})", handlerModuleDescriptor, (Object)handlerResponse.getErrorCollection());
            } else {
                log.info("Ending task (success) for handler: {}", handlerModuleDescriptor);
            }
            ServiceResult serviceResult = handlerResponse;
            return serviceResult;
        }
        catch (Exception e) {
            log.error("Exception during AnonymizationHandler {} processing", handlerModuleDescriptor, (Object)e);
            return ServiceOutcomeImpl.error(e.getMessage());
        }
    }

    private List<? extends AnonymizationHandlerModuleDescriptor<T, P>> getModuleDescriptorsForHandlers() {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(this.getModuleDescriptorClass());
        return moduleDescriptors.stream().filter(module -> module.getOrder() >= 0).sorted((Comparator<AnonymizationHandlerModuleDescriptor>)ModuleDescriptorComparator.COMPARATOR).collect(Collectors.toList());
    }

    private <U> U retryOnException(@Nonnull Callable<U> callable, int retries) throws Exception {
        int attempt = 0;
        while (true) {
            try {
                return callable.call();
            }
            catch (IOException ioe) {
                IOException lastException = ioe;
                log.warn("Exception during handler execution", (Throwable)ioe);
                if (++attempt <= retries) continue;
                throw lastException;
            }
            break;
        }
    }
}

