/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.anonymize;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserAnonymizationHandler;
import com.atlassian.jira.user.anonymize.UserAnonymizationParameter;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterSubscriptionAnonymizationHandler
implements UserAnonymizationHandler {
    private static Logger log = LoggerFactory.getLogger(FilterSubscriptionAnonymizationHandler.class);
    private final SubscriptionManager subscriptionManager;
    private final UserManager userManager;

    public FilterSubscriptionAnonymizationHandler(SubscriptionManager subscriptionManager, UserManager userManager) {
        this.subscriptionManager = subscriptionManager;
        this.userManager = userManager;
    }

    @Nonnull
    public List<AffectedEntity> getAffectedEntities(@Nonnull UserAnonymizationParameter parameter) {
        ApplicationUser user = this.userManager.getUserByKeyEvenWhenUnknown(parameter.getUserKey());
        long subscriptions = this.subscriptionManager.getSubscriptionsForUser(user).size();
        if (subscriptions > 0L) {
            return ImmutableList.of((Object)AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.ANONYMIZE).numberOfOccurrences(Long.valueOf(subscriptions)).descriptionKey("filtersubscription.title").build());
        }
        return ImmutableList.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ServiceResult update(@Nonnull UserAnonymizationParameter parameter) {
        SimpleErrorCollection error = new SimpleErrorCollection();
        try {
            this.subscriptionManager.deleteSubscriptionsForUser(this.userManager.getUserByKeyEvenWhenUnknown(parameter.getUserKey()));
        }
        catch (GenericEntityException e) {
            error.addErrorMessage(e.getMessage());
            log.error("Error while removing filter subscriptions", (Throwable)e);
        }
        finally {
            ContextUtil.updateProgress(parameter.getContext(), this.getNumberOfTasks(parameter));
        }
        return new ServiceResultImpl((ErrorCollection)error);
    }

    public int getNumberOfTasks(@Nonnull UserAnonymizationParameter userPropertyChangeParameter) {
        return 1;
    }
}

