/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.anonymize;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.model.querydsl.QSharePermissions;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionImpl;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.sharing.type.UserShareType;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserAnonymizationHandler;
import com.atlassian.jira.user.anonymize.UserAnonymizationParameter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionAnonymizationHandler
implements UserAnonymizationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PermissionAnonymizationHandler.class);
    private final ShareManager shareManager;
    private final QueryDslAccessor queryDslAccessor;
    private final PermissionSchemeManager permissionSchemeManager;

    public PermissionAnonymizationHandler(ShareManager shareManager, QueryDslAccessor queryDslAccessor, PermissionSchemeManager permissionSchemeManager) {
        this.shareManager = shareManager;
        this.queryDslAccessor = queryDslAccessor;
        this.permissionSchemeManager = permissionSchemeManager;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserAnonymizationParameter parameter) {
        long affectedPermissions;
        long affectedShares = this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)connection.newSqlQuery().select(QSharePermissions.SHARE_PERMISSIONS.entityId).from((Expression)QSharePermissions.SHARE_PERMISSIONS)).where((Predicate)QSharePermissions.SHARE_PERMISSIONS.type.eq((Object)ShareType.Name.USER.get()).and((Predicate)QSharePermissions.SHARE_PERMISSIONS.param1.eq((Object)parameter.getUserKey())))).fetchCount());
        try {
            affectedPermissions = this.permissionSchemeManager.getEntities("user", parameter.getUserKey()).size();
        }
        catch (GenericEntityException e) {
            affectedPermissions = 0L;
            LOG.error("Encountered error while listing permissions for the user", (Throwable)e);
        }
        return Stream.of(PermissionAnonymizationHandler.affectedEntity(affectedPermissions, "admin.projects.permission.scheme"), PermissionAnonymizationHandler.affectedEntity(affectedShares, "anonymization.shared.entity.link.name")).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static AffectedEntity affectedEntity(long occurrences, String description) {
        if (occurrences > 0L) {
            return AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.ANONYMIZE).descriptionKey(description).numberOfOccurrences(Long.valueOf(occurrences)).build();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ServiceResult update(@Nonnull UserAnonymizationParameter parameter) {
        SimpleErrorCollection error = new SimpleErrorCollection();
        SharePermissionImpl permission = new SharePermissionImpl(UserShareType.TYPE, parameter.getUserKey(), null, null);
        int tasksLeft = this.getNumberOfTasks(parameter);
        try {
            this.shareManager.deleteSharePermissionsLike((SharePermission)permission);
            ContextUtil.updateProgress(parameter.getContext(), 1);
            --tasksLeft;
            this.permissionSchemeManager.removeEntities("user", parameter.getUserKey());
            ContextUtil.updateProgress(parameter.getContext(), 1);
            --tasksLeft;
        }
        catch (RemoveException e) {
            error.addErrorMessage(e.getMessage());
            LOG.error("Error while removing references to the user from permission schemes", (Throwable)e);
        }
        finally {
            ContextUtil.updateProgress(parameter.getContext(), tasksLeft);
        }
        return new ServiceResultImpl((ErrorCollection)error);
    }

    public int getNumberOfTasks(@Nonnull UserAnonymizationParameter userPropertyChangeParameter) {
        return 2;
    }
}

