/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.anonymize;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.event.user.UserEditedEvent;
import com.atlassian.crowd.event.user.UserEmailChangedEvent;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.crowd.embedded.ofbiz.UserNotFoundException;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryStore;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityLink;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.Retry;
import com.atlassian.jira.user.anonymize.UserAnonymizationHandler;
import com.atlassian.jira.user.anonymize.UserAnonymizationParameter;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BaseUrl;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.SimpleWarningCollection;
import com.atlassian.jira.util.WarningCollection;
import com.atlassian.seraph.spi.rememberme.RememberMeTokenDao;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProfileAnonymizationHandler
implements UserAnonymizationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(UserProfileAnonymizationHandler.class);
    private static final int MAX_RETRIES = 1;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserManager userManager;
    private final UserKeyStore userKeyStore;
    private final CrowdService crowdService;
    private final AvatarManager avatarManager;
    private final RememberMeTokenDao rememberMeTokenDao;
    private final JiraPropertySetFactory propertySetFactory;
    private final JsonEntityPropertyManager jsonEntityPropertyManager;
    private final UserHistoryStore userHistoryStore;
    private final I18nHelper i18n;
    private final BaseUrl baseUrl;
    private final ExtendedUserDao extendedUserDao;
    private final EventPublisher eventPublisher;

    public UserProfileAnonymizationHandler(JiraAuthenticationContext jiraAuthenticationContext, UserManager userManager, UserKeyStore userKeyStore, CrowdService crowdService, AvatarManager avatarManager, RememberMeTokenDao rememberMeTokenDao, JiraPropertySetFactory propertySetFactory, JsonEntityPropertyManager jsonEntityPropertyManager, UserHistoryStore userHistoryStore, I18nHelper i18n, BaseUrl baseUrl, ExtendedUserDao extendedUserDao, EventPublisher eventPublisher) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userManager = userManager;
        this.userKeyStore = userKeyStore;
        this.crowdService = crowdService;
        this.avatarManager = avatarManager;
        this.rememberMeTokenDao = rememberMeTokenDao;
        this.propertySetFactory = propertySetFactory;
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
        this.userHistoryStore = userHistoryStore;
        this.i18n = i18n;
        this.baseUrl = baseUrl;
        this.extendedUserDao = extendedUserDao;
        this.eventPublisher = eventPublisher;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserAnonymizationParameter userAnonymizationParameter) {
        Optional<URI> uri = Optional.ofNullable(this.userManager.getUserByKey(userAnonymizationParameter.getUserKey())).map(user -> this.baseUrl.resolveAddress("/secure/ViewProfile.jspa?name=" + user.getName()));
        if (uri.isPresent()) {
            AffectedEntity affectedEntity = AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.ANONYMIZE).descriptionKey("user.profile").numberOfOccurrences(Long.valueOf(1L)).link(new AffectedEntityLink(uri.get(), "user.profile")).build();
            return ImmutableList.of((Object)affectedEntity);
        }
        return ImmutableList.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ServiceResult update(@Nonnull UserAnonymizationParameter parameter) {
        SimpleErrorCollection error = new SimpleErrorCollection();
        SimpleWarningCollection warning = new SimpleWarningCollection();
        Context context = parameter.getContext();
        int tasksNumber = this.getNumberOfTasks(parameter);
        try {
            ApplicationUser user = this.userManager.getUserByKeyEvenWhenUnknown(parameter.getUserKey());
            if (user != null && user.getId() >= 0L) {
                if (user.getDirectoryId() >= 0L) {
                    this.retryOnException((ErrorCollection)error, (WarningCollection)warning, () -> this.lambda$update$1((ErrorCollection)error, user));
                }
                this.retryOnException((ErrorCollection)error, (WarningCollection)warning, () -> this.removeAvatars(user));
                this.retryOnException((ErrorCollection)error, (WarningCollection)warning, () -> this.removeRememberMeTokens(user));
                this.retryOnException((ErrorCollection)error, (WarningCollection)warning, () -> this.removeUserPreferences(user));
                this.retryOnException((ErrorCollection)error, (WarningCollection)warning, () -> this.removeProperties(user));
                this.retryOnException((ErrorCollection)error, (WarningCollection)warning, () -> this.removeHistory(user));
            } else {
                error.addErrorMessage(this.i18n.getText("admin.errors.user.key.change.user.does.not.exist", parameter.getUserKey()));
            }
        }
        catch (Exception e) {
            LOG.error("Exception during profile anonymization handler processing", (Throwable)e);
            error.addErrorMessage(this.jiraAuthenticationContext.getI18nHelper().getText("change.handler.processing.exception", e.getMessage()));
        }
        finally {
            ContextUtil.updateProgress(context, tasksNumber);
        }
        return new ServiceResultImpl((ErrorCollection)error, (WarningCollection)warning);
    }

    private void updateCrowdUser(ErrorCollection error, ApplicationUser applicationUser) {
        UserTemplate currentUser = new UserTemplate(applicationUser.getDirectoryUser());
        UserTemplate userToUpdate = new UserTemplate((com.atlassian.crowd.model.user.User)currentUser);
        userToUpdate.setEmailAddress(this.userKeyStore.getKeyFromId(applicationUser.getId()) + "@jira.invalid");
        userToUpdate.setDisplayName(this.displayName(applicationUser));
        userToUpdate.setFirstName(null);
        userToUpdate.setLastName(null);
        try {
            if (this.extendedUserDao.isDeletedExternally(applicationUser.getDirectoryId(), applicationUser.getUsername())) {
                LOG.info("User deleted externally. Falling back to DB update.");
                com.atlassian.crowd.model.user.User updatedUser = this.extendedUserDao.update((com.atlassian.crowd.model.user.User)userToUpdate, false);
                Directory directory = this.userManager.getDirectory(Long.valueOf(applicationUser.getDirectoryId()));
                if (directory != null) {
                    this.eventPublisher.publish((Object)new UserEditedEvent((Object)this, directory, updatedUser, (com.atlassian.crowd.model.user.User)currentUser));
                    String originalEmail = currentUser.getEmailAddress();
                    if (!Objects.equals(originalEmail, updatedUser.getEmailAddress())) {
                        this.eventPublisher.publish((Object)new UserEmailChangedEvent((Object)this, directory, updatedUser, originalEmail));
                    }
                }
            } else {
                this.crowdService.updateUser((User)userToUpdate);
            }
        }
        catch (InvalidUserException | OperationNotPermittedException | UserNotFoundException e) {
            LOG.error("Error while updating Crowd user", (Throwable)e);
            error.addErrorMessage(this.i18n.getText("admin.errors.user.anonymize.user.does.not.exist", userToUpdate.getName()));
        }
    }

    private String displayName(ApplicationUser user) {
        byte[] idBytes = ByteBuffer.allocate(8).putLong(user.getId()).array();
        String idHash = DigestUtils.sha256Hex((byte[])idBytes);
        return "user-" + idHash.substring(0, 5);
    }

    private void removeAvatars(ApplicationUser user) {
        List avatars = this.avatarManager.getCustomAvatarsForOwner(IconType.USER_ICON_TYPE, user.getKey());
        for (Avatar avatar : avatars) {
            this.avatarManager.delete(avatar.getId());
        }
    }

    private void removeRememberMeTokens(ApplicationUser user) {
        this.rememberMeTokenDao.removeAllForUser(user.getName());
    }

    private void removeUserPreferences(ApplicationUser user) {
        this.propertySetFactory.buildCachingPropertySet("ApplicationUser", user.getId()).remove();
    }

    private void removeProperties(ApplicationUser user) {
        this.jsonEntityPropertyManager.deleteByEntity(EntityPropertyType.USER_PROPERTY.getDbEntityName(), user.getId());
    }

    private void removeHistory(ApplicationUser user) {
        this.userHistoryStore.removeHistoryForUser(user);
    }

    private void retryOnException(ErrorCollection errorColl, WarningCollection warningColl, Runnable runnable) {
        Retry.from(runnable).onException(e -> LOG.error("Encountered error when updating user profile", (Throwable)e)).onFail(e -> errorColl.addErrorMessage(this.i18n.getText("admin.errors.user.anonymize.retry.failed", (Object)1))).onSuccess(retries -> {
            if (retries > 0) {
                warningColl.addWarning(this.i18n.getText("admin.errors.user.anonymize.retry.warning", retries));
            }
        }).executeTimes(1);
    }

    private /* synthetic */ void lambda$update$1(ErrorCollection error, ApplicationUser user) {
        this.updateCrowdUser(error, user);
    }
}

