/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.handlers.key.info.ForeignKeyInfo;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Expression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericUserKeyChangeHandler
implements UserKeyChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(GenericUserKeyChangeHandler.class);
    protected final QueryDslAccessor queryDslAccessor;
    protected final ForeignKeyInfo foreignKeyInfo;
    protected final int numberOfTasks;

    public GenericUserKeyChangeHandler(QueryDslAccessor queryDslAccessor, ForeignKeyInfo foreignKeyInfo, int numberOfTasks) {
        this.queryDslAccessor = queryDslAccessor;
        this.foreignKeyInfo = foreignKeyInfo;
        this.numberOfTasks = numberOfTasks;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        String original = userPropertyChangeParameter.getOriginal();
        long count = this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)connection.newSqlQuery().select(this.foreignKeyInfo.getSelect()).from((Expression)this.foreignKeyInfo.getTable())).where(this.foreignKeyInfo.getWhere(original))).fetchCount());
        log.info("User {} has {} {} ({}) entities to update", new Object[]{original, count, this.foreignKeyInfo.getName(), this.foreignKeyInfo.columnsToString()});
        return count > 0L ? Lists.newArrayList((Object[])new AffectedEntity[]{AffectedEntity.newBuilder((AffectedEntityType)this.foreignKeyInfo.getAffectedEntityType()).descriptionKey(this.foreignKeyInfo.getDescriptionKey()).numberOfOccurrences(Long.valueOf(count)).build()}) : Collections.emptyList();
    }

    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return this.update(userPropertyChangeParameter, this.getNumberOfTasks(userPropertyChangeParameter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter, int numberOfTasks) {
        String original = userPropertyChangeParameter.getOriginal();
        String target = userPropertyChangeParameter.getTarget();
        Context context = userPropertyChangeParameter.getContext();
        int size = this.foreignKeyInfo.getColumns().size();
        try {
            this.queryDslAccessor.execute(connection -> {
                long count = connection.update((RelationalPath<?>)this.foreignKeyInfo.getTable()).set(this.foreignKeyInfo.getColumns(), Collections.nCopies(size, target)).where(this.foreignKeyInfo.getWhere(original)).execute();
                log.info("Updated {} {} ({}) entities for {}", new Object[]{count, this.foreignKeyInfo.getName(), this.foreignKeyInfo.columnsToString(), original});
            });
        }
        finally {
            ContextUtil.updateProgress(context, numberOfTasks);
        }
        return new ServiceResultImpl();
    }

    protected List<Long> getIdsOfAffectedEntities(String original) {
        return this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)connection.newSqlQuery().select(this.foreignKeyInfo.getSelect()).from((Expression)this.foreignKeyInfo.getTable())).where(this.foreignKeyInfo.getWhere(original))).fetch());
    }

    public String toString() {
        return this.foreignKeyInfo.columnsToString();
    }

    public int getNumberOfTasks(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return this.numberOfTasks;
    }
}

