/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.DatabaseVendor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.model.querydsl.QChangeItem;
import com.atlassian.jira.model.querydsl.QCustomField;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyString;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.handlers.key.IssueHistoryUserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.info.IssueHistoryInfo;
import com.atlassian.jira.user.anonymize.handlers.utils.MultiValueChangeItemUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueHistoryCustomFieldMultiUserKeyChangeHandler
extends IssueHistoryUserKeyChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(IssueHistoryCustomFieldMultiUserKeyChangeHandler.class);
    private static final String DESCRIPTION_KEY = "anonymization.fk.issueHistory.customField";
    private static final String FIELDTYPE = "com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker";

    public IssueHistoryCustomFieldMultiUserKeyChangeHandler(JiraAuthenticationContext jiraAuthenticationContext, QueryDslAccessor queryDslAccessor, DatabaseAccessor databaseAccessor, IssueManager issueManager, IssueIndexingService issueIndexingService, int stepNumber) {
        super(jiraAuthenticationContext, queryDslAccessor, databaseAccessor, issueManager, issueIndexingService, stepNumber, 0, (List<IssueHistoryInfo>)ImmutableList.of((Object)new CustomInfo(QChangeItem.CHANGE_ITEM.oldvalue), (Object)new CustomInfo(QChangeItem.CHANGE_ITEM.newvalue)));
    }

    @Override
    protected String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        String original = userPropertyChangeParameter.getOriginal();
        String target = userPropertyChangeParameter.getTarget();
        try {
            long updated = this.getInfos().stream().mapToLong(arg_0 -> this.lambda$update$1(original, target, (ErrorCollection)errors, arg_0)).sum();
            log.info("Updated {} {} entities for {}", new Object[]{updated, QChangeItem.CHANGE_ITEM.getTableName(), original});
        }
        finally {
            ContextUtil.updateProgress(userPropertyChangeParameter.getContext(), this.getNumberOfTasks(userPropertyChangeParameter));
        }
        return new ServiceResultImpl((ErrorCollection)errors);
    }

    private long updateCustomField(Long id, IssueHistoryInfo info, String original, String target) {
        return this.queryDslAccessor.executeQuery(connection -> {
            String value = (String)((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)info.getColumn().get()).from((Expression)info.getTable())).where((Predicate)QChangeItem.CHANGE_ITEM.id.eq((Object)id))).fetchFirst();
            String newMultiUsers = MultiValueChangeItemUtil.replace(value, original, target);
            return connection.update((RelationalPath<?>)info.getTable()).set(info.getColumn().get(), (Object)newMultiUsers).where((Predicate)QChangeItem.CHANGE_ITEM.id.eq((Object)id)).execute();
        });
    }

    private /* synthetic */ long lambda$update$1(String original, String target, ErrorCollection errors, IssueHistoryInfo info) {
        return this.getAffectedEntitiesIds(original, info).stream().mapToLong(id -> {
            try {
                return this.updateCustomField((Long)id, info, original, target);
            }
            catch (Exception e) {
                log.error(String.format("Exception during multiuserpicker update %d", id), (Throwable)e);
                errors.addErrorMessage(this.jiraAuthenticationContext.getI18nHelper().getText("change.handler.processing.exception", e.getMessage()));
                return 0L;
            }
        }).sum();
    }

    private static class CustomInfo
    extends IssueHistoryInfo {
        private CustomInfo(StringPath column) {
            super(null, column);
        }

        @Override
        public Predicate getWhere(String original, DatabaseVendor databaseVendor) {
            StringPath translatedField = QOSPropertyString.O_S_PROPERTY_STRING.value;
            if (DatabaseVendor.SQL_SERVER.equals((Object)databaseVendor)) {
                translatedField = Expressions.stringTemplate((String)"cast({0} as nvarchar(max))", (Object[])new Object[]{QOSPropertyString.O_S_PROPERTY_STRING.value});
            }
            return QChangeItem.CHANGE_ITEM.fieldtype.eq((Object)"custom").and((Predicate)this.column.contains("[" + original + ", ").or((Predicate)this.column.contains("[" + original + "]")).or((Predicate)this.column.contains(", " + original + ", ")).or((Predicate)this.column.contains(", " + original + "]"))).and((Predicate)QChangeItem.CHANGE_ITEM.field.in((SubQueryExpression)((SQLQuery)SQLExpressions.select((Expression)translatedField).from(new Expression[]{QOSPropertyString.O_S_PROPERTY_STRING, QCustomField.CUSTOM_FIELD, QOSPropertyEntry.O_S_PROPERTY_ENTRY})).where(new Predicate[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq(QOSPropertyString.O_S_PROPERTY_STRING.id), QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)"CustomField"), QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.like("jira.translation.custom.field%.name.%"), QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)IssueHistoryCustomFieldMultiUserKeyChangeHandler.FIELDTYPE), QCustomField.CUSTOM_FIELD.id.eq(QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId)})).or((Predicate)QChangeItem.CHANGE_ITEM.field.in((SubQueryExpression)((SQLQuery)SQLExpressions.select((Expression)QCustomField.CUSTOM_FIELD.name).from((Expression)QCustomField.CUSTOM_FIELD)).where((Predicate)QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)IssueHistoryCustomFieldMultiUserKeyChangeHandler.FIELDTYPE)))));
        }
    }
}

