/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.key;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeManager;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.UserPropertyChangeService;
import com.atlassian.jira.user.anonymize.key.UserKeyChangeManager;
import com.atlassian.jira.user.anonymize.key.UserKeyChangeService;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class DefaultUserKeyChangeService
extends UserKeyChangeService {
    private final UserManager userManager;
    private final UserKeyChangeManager userKeyChangeManager;
    private final UserKeyStore userKeyStore;

    public DefaultUserKeyChangeService(UserManager userManager, UserKeyChangeManager userKeyChangeManager, UserKeyStore userKeyStore) {
        this.userManager = userManager;
        this.userKeyChangeManager = userKeyChangeManager;
        this.userKeyStore = userKeyStore;
    }

    @Override
    @Nonnull
    protected UserPropertyChangeManager<UserKeyChangeHandler, UserPropertyChangeParameter> getManager() {
        return this.userKeyChangeManager;
    }

    @Override
    @Nonnull
    protected String getHandlerDescriptionKey() {
        return "admin.user.key.change.handler.key.change";
    }

    @Override
    @Nonnull
    public UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter> validateUserPropertyChange(@Nonnull UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter> userPropertyChangeRequest) {
        UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter> validateCommonResult = this.validateCommon(userPropertyChangeRequest);
        if (!validateCommonResult.isValid()) {
            return validateCommonResult;
        }
        ApplicationUser loggedInUser = userPropertyChangeRequest.getLoggedInUser();
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        String originalUserKey = userPropertyChangeRequest.getUserPropertyChangeParameter().getOriginal();
        ApplicationUser userToUpdate = this.userManager.getUserByKeyEvenWhenUnknown(originalUserKey);
        if (userToUpdate == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.user.does.not.exist", originalUserKey));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        if (userToUpdate.getDirectoryId() == -1L && userToUpdate.getId().equals(-1L)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.user.does.not.exist", originalUserKey));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        String anonymizedUserKey = userPropertyChangeRequest.getUserPropertyChangeParameter().getTarget();
        Optional<ApplicationUserEntity> existingUserWithDestinationKey = this.userKeyStore.getUserForKey(anonymizedUserKey);
        if (existingUserWithDestinationKey.isPresent()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.destination.key.already.exists", anonymizedUserKey));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest);
    }

    @Override
    @Nonnull
    public UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter> validateUserPropertyChangeInOtherEntities(@Nonnull UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter> userPropertyChangeRequest) {
        return this.validateCommon(userPropertyChangeRequest);
    }

    @Nonnull
    private UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter> validateCommon(@Nonnull UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter> userPropertyChangeRequest) {
        ApplicationUser loggedInUser = userPropertyChangeRequest.getLoggedInUser();
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        String originalUserKey = userPropertyChangeRequest.getUserPropertyChangeParameter().getOriginal();
        ApplicationUser userToUpdate = this.userManager.getUserByKeyEvenWhenUnknown(originalUserKey);
        if (!this.isAdministrator(loggedInUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.no.permission"));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        if (!this.isSysAdmin(loggedInUser) && this.isSysAdmin(userToUpdate)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.must.be.sysadmin.to.edit.sysadmin"));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        if (Objects.equals(userPropertyChangeRequest.getUserPropertyChangeParameter().getOriginal(), userPropertyChangeRequest.getUserPropertyChangeParameter().getTarget())) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.keys.equal"));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        if (StringUtils.isBlank((CharSequence)userPropertyChangeRequest.getUserPropertyChangeParameter().getTarget())) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.anonymize.key.blank"));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        if (userPropertyChangeRequest.getLoggedInUser().getKey().equals(userPropertyChangeRequest.getUserPropertyChangeParameter().getOriginal())) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.key.change.yourself"));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest);
    }
}

