/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.name;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.event.user.anonymize.UserNameChangedEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.AnonymizationHandlerModuleDescriptor;
import com.atlassian.jira.user.anonymize.UserNameChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.name.UserNameChangeHandlerModuleDescriptor;
import com.atlassian.jira.user.anonymize.name.UserNameChangeManager;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.PluginAccessor;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserNameChangeManager
extends UserNameChangeManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultUserNameChangeManager.class);
    private final UserManager userManager;
    private final ExtendedUserDao userDao;
    private final UserKeyStore userKeyStore;
    private final EventPublisher eventPublisher;

    public DefaultUserNameChangeManager(PluginAccessor pluginAccessor, UserManager userManager, ExtendedUserDao userDao, UserKeyStore userKeyStore, EventPublisher eventPublisher) {
        super(pluginAccessor);
        this.userManager = userManager;
        this.userDao = userDao;
        this.userKeyStore = userKeyStore;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void changeProperty(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        ApplicationUser jiraUser = this.userManager.getUserByNameEvenWhenUnknown(userPropertyChangeParameter.getOriginal());
        if (jiraUser.getDirectoryId() == -1L) {
            this.changeNameForDeletedUser(userPropertyChangeParameter, jiraUser);
        } else {
            this.changeNameForExistingUser(userPropertyChangeParameter, jiraUser);
        }
        this.eventPublisher.publish((Object)new UserNameChangedEvent(userPropertyChangeParameter.getOriginal(), userPropertyChangeParameter.getTarget()));
    }

    private void changeNameForDeletedUser(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter, ApplicationUser jiraUser) {
        this.userKeyStore.renameUser(jiraUser.getUsername(), userPropertyChangeParameter.getTarget());
    }

    private void changeNameForExistingUser(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter, ApplicationUser jiraUser) {
        try {
            UserTemplate crowdUser = new UserTemplate(jiraUser.getUsername(), jiraUser.getDirectoryId());
            String newUsername = userPropertyChangeParameter.getTarget();
            User updatedUser = this.userDao.rename((User)crowdUser, newUsername);
            Directory directory = this.userManager.getDirectory(Long.valueOf(jiraUser.getDirectoryId()));
            if (directory != null) {
                this.eventPublisher.publish((Object)new UserRenamedEvent((Object)this, directory, updatedUser, jiraUser.getUsername()));
            }
        }
        catch (UserAlreadyExistsException | UserNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected Class<? extends AnonymizationHandlerModuleDescriptor<UserNameChangeHandler, UserPropertyChangeParameter>> getModuleDescriptorClass() {
        return UserNameChangeHandlerModuleDescriptor.class;
    }
}

