/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.operations;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.ServiceOutcomeWithWarnings;
import com.atlassian.jira.user.anonymize.ServiceResultWithWarnings;
import com.atlassian.jira.user.anonymize.UserAnonymizationParameter;
import com.atlassian.jira.user.anonymize.UserAnonymizationService;
import com.atlassian.jira.user.anonymize.UserPropertyChangeService;
import com.atlassian.jira.user.anonymize.operations.AnonymizeOperationStep;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnonymizePluginPointsStep
implements AnonymizeOperationStep {
    private static final Logger log = LoggerFactory.getLogger(AnonymizePluginPointsStep.class);
    private final UserAnonymizationService userAnonymizationService;

    public AnonymizePluginPointsStep(UserAnonymizationService userAnonymizationService) {
        this.userAnonymizationService = userAnonymizationService;
    }

    @Override
    @Nonnull
    public Optional<AnonymizeUserService.SingleOperationReport<Void>> performOperation(@Nonnull AnonymizeUserService.OperationsReport<Void> anonymizeReport, @Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull Context asyncTaskContext) {
        AnonymizeUserService.AnonymizeProcessData processData = validationResult.getProcessData();
        Optional<UserAnonymizationParameter> userAnonymizationParameterOptional = this.getUserAnonymizationParameter(processData, asyncTaskContext);
        if (!userAnonymizationParameterOptional.isPresent()) {
            log.warn("No parameter present. Skipping anonymizing in extension points");
            return Optional.empty();
        }
        UserAnonymizationParameter parameter = userAnonymizationParameterOptional.get();
        log.info("Anonymizing in extension points for {}", (Object)parameter);
        UserPropertyChangeService.UserPropertyChangeValidationResult<UserAnonymizationParameter> operationValidationResult = this.userAnonymizationService.validateUserPropertyChangeInOtherEntities(new UserPropertyChangeService.UserPropertyChangeRequest<UserAnonymizationParameter>(validationResult.getRequest().getExecutor(), parameter));
        if (!operationValidationResult.isValid()) {
            return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_ANONYMIZE_PLUGIN_POINTS, new ServiceOutcomeWithWarnings<Object>(null, operationValidationResult.getErrorCollection(), (Map<String, ErrorCollection>)ImmutableMap.of())));
        }
        ServiceResultWithWarnings result = this.userAnonymizationService.userPropertyChangeInOtherEntities(operationValidationResult);
        return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_ANONYMIZE_PLUGIN_POINTS, new ServiceOutcomeWithWarnings<Object>(null, result.getErrorCollection(), result.getWarnings())));
    }

    @Override
    @Nonnull
    public ServiceResult validate(@Nonnull AnonymizeUserService.AnonymizeProcessData anonymizationProcessData, I18nHelper i18nHelper, boolean preValidate) {
        return ServiceOutcomeImpl.ok(null);
    }

    @Override
    @Nonnull
    public ServiceOutcomeWithWarnings<Collection<AffectedEntity>> getAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationData) {
        UserAnonymizationParameter parameter = this.getUserAnonymizationParameterForAffectedEntities(anonymizationData);
        return this.userAnonymizationService.getAffectedEntities(new UserPropertyChangeService.UserPropertyChangeRequest<UserAnonymizationParameter>(anonymizationData.getAnonymizeUserRequest().getExecutor(), parameter));
    }

    @Override
    @Nonnull
    public AnonymizeUserService.AnonymizeOperation getAnonymizeOperation() {
        return AnonymizeUserService.AnonymizeOperation.USER_ANONYMIZE_PLUGIN_POINTS;
    }

    @Override
    public int getNumberOfTasks(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        if (!validationResult.isValid()) {
            return 0;
        }
        AnonymizeUserService.AnonymizeProcessData processData = validationResult.getProcessData();
        Optional<UserAnonymizationParameter> userAnonymizationParameter = this.getUserAnonymizationParameter(processData, Contexts.nullContext());
        return userAnonymizationParameter.map(this.userAnonymizationService::getNumberOfTasks).orElse(0);
    }

    @Nonnull
    private Optional<UserAnonymizationParameter> getUserAnonymizationParameter(@Nullable AnonymizeUserService.AnonymizeProcessData anonymizationProcessData, @Nonnull Context asyncTaskContext) {
        if (anonymizationProcessData == null || anonymizationProcessData.getUser() == null) {
            return Optional.empty();
        }
        return Optional.of(new UserAnonymizationParameter(anonymizationProcessData.getUser().getKey(), asyncTaskContext));
    }

    @Nonnull
    private UserAnonymizationParameter getUserAnonymizationParameterForAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationProcessData) {
        return this.getUserAnonymizationParameter(anonymizationProcessData, Contexts.nullContext()).orElseGet(() -> new UserAnonymizationParameter(anonymizationProcessData.getAnonymizeUserRequest().getUserKey(), Contexts.nullContext()));
    }
}

