/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.ownership;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.OwnershipTransferHandler;
import com.atlassian.jira.user.anonymize.OwnershipTransferParameter;
import com.atlassian.jira.user.anonymize.UserPropertyChangeManager;
import com.atlassian.jira.user.anonymize.UserPropertyChangeService;
import com.atlassian.jira.user.anonymize.ownership.OwnershipTransferChangeManager;
import com.atlassian.jira.user.anonymize.ownership.OwnershipTransferChangeService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class DefaultOwnershipTransferChangeService
extends OwnershipTransferChangeService {
    private final UserManager userManager;
    private final OwnershipTransferChangeManager ownershipTransferChangeManager;

    public DefaultOwnershipTransferChangeService(UserManager userManager, OwnershipTransferChangeManager ownershipTransferChangeManager) {
        this.userManager = userManager;
        this.ownershipTransferChangeManager = ownershipTransferChangeManager;
    }

    @Override
    @Nonnull
    protected UserPropertyChangeManager<OwnershipTransferHandler, OwnershipTransferParameter> getManager() {
        return this.ownershipTransferChangeManager;
    }

    @Override
    @Nonnull
    public UserPropertyChangeService.UserPropertyChangeValidationResult<OwnershipTransferParameter> validateUserPropertyChange(@Nonnull UserPropertyChangeService.UserPropertyChangeRequest<OwnershipTransferParameter> userPropertyChangeRequest) {
        return new UserPropertyChangeService.UserPropertyChangeValidationResult<OwnershipTransferParameter>(userPropertyChangeRequest);
    }

    @Override
    @Nonnull
    public UserPropertyChangeService.UserPropertyChangeValidationResult<OwnershipTransferParameter> validateUserPropertyChangeInOtherEntities(@Nonnull UserPropertyChangeService.UserPropertyChangeRequest<OwnershipTransferParameter> userPropertyChangeRequest) {
        ApplicationUser loggedInUser = userPropertyChangeRequest.getLoggedInUser();
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        OwnershipTransferParameter request = userPropertyChangeRequest.getUserPropertyChangeParameter();
        if (!this.isAdministrator(loggedInUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.new.owner.change.no.permission"));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<OwnershipTransferParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        if (StringUtils.isBlank((CharSequence)request.getTransferToUserKey())) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.new.owner.not.present"));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<OwnershipTransferParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        if (request.getTransferToUserKey().equals(request.getCurrentUserKey())) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.new.owner.has.to.be.different.than.anonymized.user"));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<OwnershipTransferParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        ApplicationUser newOwner = this.userManager.getUserByKey(request.getTransferToUserKey());
        if (newOwner == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.new.owner.not.found", request.getTransferToUserKey()));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<OwnershipTransferParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        if (!newOwner.isActive()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.new.owner.has.to.be.active"));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<OwnershipTransferParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        return new UserPropertyChangeService.UserPropertyChangeValidationResult<OwnershipTransferParameter>(userPropertyChangeRequest);
    }

    @Override
    @Nonnull
    protected String getHandlerDescriptionKey() {
        return "admin.transfer.ownership.change.handler.name.change";
    }
}

