/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.stats;

import com.atlassian.jira.util.stats.MutableLongStats;

public class LongStats {
    public final long count;
    public final long min;
    public final long max;
    public final long sum;
    public final long avg;

    private LongStats(long count, long min, long max, long sum) {
        this.count = count;
        this.min = min == Long.MAX_VALUE ? 0L : min;
        this.max = max == Long.MIN_VALUE ? 0L : max;
        this.sum = sum;
        this.avg = count > 0L ? sum / count : 0L;
    }

    static LongStats create(MutableLongStats mutableLongStats) {
        return new LongStats(mutableLongStats.count.get(), mutableLongStats.min.get(), mutableLongStats.max.get(), mutableLongStats.sum.get());
    }

    public long count() {
        return this.count;
    }

    public long min() {
        return this.min;
    }

    public long max() {
        return this.max;
    }

    public long sum() {
        return this.sum;
    }

    public long avg() {
        return this.avg;
    }
}

