/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.appconsistency.integrity.IntegrityCheckManager;
import com.atlassian.jira.appconsistency.integrity.amendment.Amendment;
import com.atlassian.jira.appconsistency.integrity.check.Check;
import com.atlassian.jira.appconsistency.integrity.integritycheck.IntegrityCheck;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import webwork.action.ActionContext;

@WebSudoRequired
public class IntegrityChecker
extends JiraWebActionSupport {
    private final IntegrityCheckManager integrityCheckManager;
    private final com.atlassian.jira.appconsistency.integrity.IntegrityChecker integrityChecker;
    public static final String INTEGRITY_CHECK_PREFIX = "integrity_";
    public static final String CHECK_PREFIX = "check_";
    private String check;
    private String fix;
    private String back;
    private Map<Check, List<Amendment>> results = null;
    private static final String RESULT_NOT_POPULATED = "Check result has not been populated yet.";

    public IntegrityChecker(IntegrityCheckManager integrityCheckManager, com.atlassian.jira.appconsistency.integrity.IntegrityChecker integrityChecker) {
        this.integrityCheckManager = integrityCheckManager;
        this.integrityChecker = integrityChecker;
    }

    protected void doValidation() {
        if (!(TextUtils.stringSet((String)this.getCheck()) || TextUtils.stringSet((String)this.getFix()) || TextUtils.stringSet((String)this.getBack()))) {
            this.addErrorMessage(this.getText("admin.integritychecker.error.no.function"));
        } else if (!(this.isCheck() || this.isFix() || this.isBack())) {
            this.addErrorMessage(this.getText("admin.integritychecker.error.no.function"));
        }
        List<Long> checkIds = this.getCheckIds();
        if (this.isCheck() && checkIds.isEmpty()) {
            this.addErrorMessage(this.getText("admin.integritychecker.error.one.check"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.isCheck()) {
            this.results = this.integrityChecker.previewWithIds(this.getCheckIds());
            return "preview";
        }
        if (this.isFix()) {
            this.results = this.integrityChecker.correctWithIds(this.getCheckIds());
            return "correct";
        }
        if (this.isBack()) {
            return this.getRedirect("IntegrityChecker!default.jspa");
        }
        return "input";
    }

    public int getTotalResults() {
        int total = 0;
        Map<Check, List<Amendment>> results = this.getResults();
        if (results != null) {
            for (Check o : results.keySet()) {
                List<Amendment> result = results.get(o);
                if (result == null) continue;
                for (Amendment amendment : result) {
                    if (!amendment.isCorrection()) continue;
                    ++total;
                }
            }
        }
        return total;
    }

    public List getIntegrityChecks() {
        return this.integrityCheckManager.getIntegrityChecks();
    }

    public String getCheck() {
        return this.check;
    }

    public void setCheck(String check) {
        this.check = check;
    }

    public String getFix() {
        return this.fix;
    }

    public void setFix(String fix) {
        this.fix = fix;
    }

    public String getBack() {
        return this.back;
    }

    public void setBack(String back) {
        this.back = back;
    }

    public Map<Check, List<Amendment>> getResults() {
        if (this.results == null) {
            throw new IllegalStateException(RESULT_NOT_POPULATED);
        }
        return this.results;
    }

    public boolean isHasCorrectableResults() {
        Map<Check, List<Amendment>> results = this.getResults();
        for (Check o : results.keySet()) {
            if (!this.isHasCorrectableResults(o)) continue;
            return true;
        }
        return false;
    }

    public boolean isHasWarningResults(Check check) {
        List<Amendment> result = this.results.get(check);
        if (result != null && !result.isEmpty()) {
            for (Amendment amendment : result) {
                if (!amendment.isWarning()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isHasCorrectableResults(Check check) {
        List<Amendment> result = this.results.get(check);
        if (result != null && !result.isEmpty()) {
            for (Amendment amendment : result) {
                if (!amendment.isError()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isIntegrityCheckAvailable(IntegrityCheck integrityCheck) {
        if (!integrityCheck.isAvailable()) {
            return false;
        }
        if (this.isBack()) {
            return true;
        }
        if (this.isCheck()) {
            return this.isHasCorrectableResults(integrityCheck);
        }
        if (this.isFix()) {
            return false;
        }
        throw new IllegalStateException("Invalid function was selected.");
    }

    public boolean isHasCorrectableResults(IntegrityCheck integrityCheck) {
        List<? extends Check> checks = integrityCheck.getChecks();
        for (Check check : checks) {
            if (!this.isHasCorrectableResults(check)) continue;
            return true;
        }
        return false;
    }

    public boolean isCheckAvailable(Check check) {
        if (!check.isAvailable()) {
            return false;
        }
        if (this.isBack()) {
            return true;
        }
        if (this.isCheck()) {
            return this.isHasCorrectableResults(check);
        }
        if (this.isFix()) {
            return false;
        }
        throw new IllegalStateException("Invalid function was selected.");
    }

    public String getIntegrityCheckPrefix() {
        return INTEGRITY_CHECK_PREFIX;
    }

    public String getCheckPrefix() {
        return this.getIntegrityCheckPrefix() + CHECK_PREFIX;
    }

    public String getCheckId(Check check) {
        return this.getCheckPrefix() + check.getIntegrityCheck().getId().toString() + "_" + check.getId().toString();
    }

    public boolean isChecked(Check check) {
        return ActionContext.getParameters().containsKey(this.getCheckId(check));
    }

    private List<Long> getCheckIds() {
        ArrayList<Long> checkIds = new ArrayList<Long>();
        Map parameters = ActionContext.getParameters();
        Set keys = parameters.keySet();
        for (Object key1 : keys) {
            String key = (String)key1;
            if (!key.startsWith(this.getCheckPrefix())) continue;
            try {
                checkIds.add(Long.valueOf(((String[])parameters.get(key))[0]));
            }
            catch (NumberFormatException e) {
                this.log.error((Object)e, (Throwable)e);
            }
        }
        return checkIds;
    }

    private boolean isCheck() {
        return this.check != null;
    }

    private boolean isFix() {
        return this.fix != null;
    }

    private boolean isBack() {
        return this.back != null;
    }
}

