/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.eventtype;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.event.type.EventTypeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;

@WebSudoRequired
public class ListEventTypes
extends JiraWebActionSupport {
    private static final int SHORT_LIST_COUNT = 3;
    private final EventTypeManager eventTypeManager;
    private final WorkflowManager workflowManager;
    private final TemplateManager templateManager;
    private String name;
    private String description;
    private Long templateId;
    private String type;
    private Long eventTypeId;
    private boolean confirmed;
    private List<Scheme> allNotificationSchemes;
    Collection<JiraWorkflow> workflows = null;

    public ListEventTypes(EventTypeManager eventTypeManager, WorkflowManager workflowManager, TemplateManager templateManager) {
        this.eventTypeManager = eventTypeManager;
        this.workflowManager = workflowManager;
        this.templateManager = templateManager;
    }

    protected String doExecute() throws Exception {
        return "success";
    }

    @RequiresXsrfCheck
    public String doAddEventType() {
        if (!TextUtils.stringSet((String)this.name)) {
            this.addError("name", this.getText("admin.event.types.errors.specify.name"));
        } else if (this.eventTypeManager.isEventTypeExists(this.name)) {
            this.addError("name", this.getText("admin.event.types.errors.not.unique"));
        }
        if (this.templateId == null || this.templateId == -1L) {
            this.addError("templateId", this.getText("admin.event.types.errors.select.template"));
        }
        if (this.invalidInput()) {
            return "input";
        }
        EventType newEventType = new EventType(this.name, this.description, this.templateId);
        this.eventTypeManager.addEventType(newEventType);
        this.setTemplateId(-1L);
        this.setName(null);
        this.setDescription(null);
        return this.getRedirect("ListEventTypes.jspa");
    }

    @RequiresXsrfCheck
    public String doDeleteEventType() {
        EventType eventType = this.eventTypeManager.getEventType(this.eventTypeId);
        if (!this.eventTypeManager.isActive(eventType)) {
            if (this.confirmed) {
                this.eventTypeManager.deleteEventType(this.eventTypeId);
                if (this.invalidInput()) {
                    return "error";
                }
                return this.getRedirect("ListEventTypes.jspa");
            }
            return "input";
        }
        this.addErrorMessage(this.getText("admin.event.types.errors.delete.active"));
        return "input";
    }

    @RequiresXsrfCheck
    public String doEditEventType() {
        if (this.confirmed) {
            if (TextUtils.stringSet((String)this.name)) {
                if (this.eventTypeManager.isEventTypeExists(this.name) && !this.name.equals(this.eventTypeManager.getEventType(this.eventTypeId).getName())) {
                    this.addError("name", this.getText("admin.event.types.errors.not.unique"));
                }
            } else {
                this.addError("name", this.getText("admin.event.types.errors.specify.name"));
            }
            if (this.templateId == null || this.templateId == -1L) {
                this.addError("templateId", this.getText("admin.event.types.errors.select.template"));
            }
            if (this.invalidInput()) {
                return "input";
            }
            this.eventTypeManager.editEventType(this.eventTypeId, this.name, this.description, this.templateId);
            this.setName(null);
            this.setDescription(null);
            this.setTemplateId(-1L);
            return this.getRedirect("ListEventTypes.jspa");
        }
        return "input";
    }

    public String getStepId(String workflowName, long actionDescriptorId) {
        return this.workflowManager.getStepId(actionDescriptorId, workflowName);
    }

    public List getShortList(Collection<ActionDescriptor> transitions) {
        int count = 0;
        ArrayList<ActionDescriptor> shortList = new ArrayList<ActionDescriptor>();
        for (ActionDescriptor transition : transitions) {
            shortList.add(transition);
            if (++count < 3) continue;
            break;
        }
        return shortList;
    }

    public EventTypeManager getEventTypeManager() {
        return this.eventTypeManager;
    }

    public MultiMap getAssociatedWorkflows(EventType eventType) {
        Collection<JiraWorkflow> workflows = this.getWorkflows();
        Long eventTypeId = eventType.getId();
        MultiHashMap workflowTransitionMap = new MultiHashMap();
        for (JiraWorkflow workflow : workflows) {
            Map transitionPostFunctionMap = this.workflowManager.getPostFunctionsForWorkflow(workflow);
            Set keys = transitionPostFunctionMap.keySet();
            for (ActionDescriptor actionDescriptor : keys) {
                Collection postFunctions = (Collection)transitionPostFunctionMap.get(actionDescriptor);
                for (FunctionDescriptor functionDescriptor : postFunctions) {
                    if (!functionDescriptor.getArgs().containsKey("eventTypeId") || !eventTypeId.equals(new Long((String)functionDescriptor.getArgs().get("eventTypeId")))) continue;
                    workflowTransitionMap.put((Object)workflow.getName(), (Object)actionDescriptor);
                }
            }
        }
        return workflowTransitionMap;
    }

    private Collection<JiraWorkflow> getWorkflows() {
        if (this.workflows == null) {
            this.workflows = this.workflowManager.getWorkflows();
        }
        return this.workflows;
    }

    public Map<Long, String> getAssociatedNotificationSchemes(EventType eventType) {
        Long eventTypeId = eventType.getId();
        List<Scheme> notificationSchemes = this.getAllNotificationSchemes();
        HashMap<Long, String> associatedSchemes = new HashMap<Long, String>();
        for (Scheme notificationScheme : notificationSchemes) {
            for (SchemeEntity schemeEntity : notificationScheme.getEntities()) {
                if (!eventTypeId.equals(schemeEntity.getEntityTypeId())) continue;
                associatedSchemes.put((long)notificationScheme.getId(), notificationScheme.getName());
            }
        }
        return associatedSchemes;
    }

    private List<Scheme> getAllNotificationSchemes() {
        if (this.allNotificationSchemes == null) {
            this.allNotificationSchemes = ComponentAccessor.getNotificationSchemeManager().getSchemeObjects();
        }
        return this.allNotificationSchemes;
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isConfirmed() {
        return this.confirmed;
    }

    public void setConfirmed(boolean confirmed) {
        this.confirmed = confirmed;
    }

    public Long getEventTypeId() {
        return this.eventTypeId;
    }

    public void setEventTypeId(Long eventTypeId) {
        this.eventTypeId = eventTypeId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }
}

